/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.mtj;

import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.Matrix;

public class DenseMatrixByte
extends AbstractMatrix {
    private final byte[] data;
    private boolean unsigned = true;
    private final double max = 256.0;

    public DenseMatrixByte(int n, int n2, boolean bl) {
        super(n, n2);
        this.data = new byte[n * n2];
        this.unsigned = bl;
    }

    public final Matrix copy() {
        DenseMatrixByte denseMatrixByte = new DenseMatrixByte(this.numRows, this.numColumns, this.unsigned);
        for (int i = 0; i < this.numColumns; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                denseMatrixByte.set(j, i, this.get(j, i));
            }
        }
        return denseMatrixByte;
    }

    public final double get(int n, int n2) {
        short s = this.data[n + n2 * this.numRows];
        if (this.unsigned && s < 0) {
            return 256.0 + (double)s;
        }
        return s;
    }

    public final byte getByte(int n, int n2) {
        return this.data[n + n2 * this.numRows];
    }

    public final byte[] getByteData() {
        return this.data;
    }

    public final void set(int n, int n2, double d) {
        this.data[n + n2 * this.numRows] = (byte)d;
    }
}

