/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.org.apache.tools.zip;

import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import se.prediktera.map.common.org.apache.tools.zip.AsiExtraField;
import se.prediktera.map.common.org.apache.tools.zip.JarMarker;
import se.prediktera.map.common.org.apache.tools.zip.UnrecognizedExtraField;
import se.prediktera.map.common.org.apache.tools.zip.ZipExtraField;
import se.prediktera.map.common.org.apache.tools.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static Hashtable implementations = new Hashtable();

    public static ZipExtraField createExtraField(ZipShort zipShort) throws ZipException {
        Class clazz = (Class)implementations.get(zipShort);
        if (clazz != null) {
            try {
                return (ZipExtraField)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new ZipException(exception.getMessage());
            }
        }
        UnrecognizedExtraField unrecognizedExtraField = new UnrecognizedExtraField();
        unrecognizedExtraField.setHeaderId(zipShort);
        return unrecognizedExtraField;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] zipExtraFieldArray) {
        int n = 4 * zipExtraFieldArray.length;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            n += zipExtraField.getCentralDirectoryLength().getValue();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            System.arraycopy(zipExtraField.getHeaderId().getBytes(), 0, byArray, n2, 2);
            System.arraycopy(zipExtraField.getCentralDirectoryLength().getBytes(), 0, byArray, n2 + 2, 2);
            byte[] byArray2 = zipExtraField.getCentralDirectoryData();
            System.arraycopy(byArray2, 0, byArray, n2 + 4, byArray2.length);
            n2 += byArray2.length + 4;
        }
        return byArray;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] zipExtraFieldArray) {
        int n = 4 * zipExtraFieldArray.length;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            n += zipExtraField.getLocalFileDataLength().getValue();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            System.arraycopy(zipExtraField.getHeaderId().getBytes(), 0, byArray, n2, 2);
            System.arraycopy(zipExtraField.getLocalFileDataLength().getBytes(), 0, byArray, n2 + 2, 2);
            byte[] byArray2 = zipExtraField.getLocalFileDataData();
            System.arraycopy(byArray2, 0, byArray, n2 + 4, byArray2.length);
            n2 += byArray2.length + 4;
        }
        return byArray;
    }

    public static ZipExtraField[] parse(byte[] byArray) throws ZipException {
        Object[] objectArray;
        int n;
        int n2;
        Vector<ZipExtraField> vector = new Vector<ZipExtraField>();
        for (n = 0; n <= byArray.length - 4; n += n2 + 4) {
            objectArray = new ZipShort(byArray, n);
            n2 = new ZipShort(byArray, n + 2).getValue();
            if (n + 4 + n2 > byArray.length) {
                throw new ZipException("data starting at " + n + " is in unknown format");
            }
            ZipExtraField zipExtraField = ExtraFieldUtils.createExtraField((ZipShort)objectArray);
            zipExtraField.parseFromLocalFileData(byArray, n + 4, n2);
            vector.addElement(zipExtraField);
        }
        if (n != byArray.length) {
            throw new ZipException("data starting at " + n + " is in unknown format");
        }
        objectArray = new ZipExtraField[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void register(Class clazz) {
        try {
            ZipExtraField zipExtraField = (ZipExtraField)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            implementations.put(zipExtraField.getHeaderId(), clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(JarMarker.class);
    }
}

