/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.org.apache.tools.zip;

import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipException;
import se.prediktera.map.common.org.apache.tools.zip.ExtraFieldUtils;
import se.prediktera.map.common.org.apache.tools.zip.ZipExtraField;
import se.prediktera.map.common.org.apache.tools.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private static final int SHORT_MASK = 65535;
    private static final int SHORT_SHIFT = 16;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private Vector extraFields = null;
    private String name = null;

    public ZipEntry(java.util.zip.ZipEntry zipEntry) throws ZipException {
        super(zipEntry);
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(String string) {
        super(string);
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this((java.util.zip.ZipEntry)zipEntry);
        this.setInternalAttributes(zipEntry.getInternalAttributes());
        this.setExternalAttributes(zipEntry.getExternalAttributes());
        this.setExtraFields(zipEntry.getExtraFields());
    }

    protected ZipEntry() {
        super("");
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        if (this.extraFields == null) {
            this.extraFields = new Vector();
        }
        ZipShort zipShort = zipExtraField.getHeaderId();
        boolean bl = false;
        int n = this.extraFields.size();
        for (int i = 0; !bl && i < n; ++i) {
            if (!((ZipExtraField)this.extraFields.elementAt(i)).getHeaderId().equals(zipShort)) continue;
            this.extraFields.setElementAt(zipExtraField, i);
            bl = true;
        }
        if (!bl) {
            this.extraFields.addElement(zipExtraField);
        }
        this.setExtra();
    }

    @Override
    public Object clone() {
        ZipEntry zipEntry = (ZipEntry)super.clone();
        zipEntry.extraFields = this.extraFields != null ? (Vector)this.extraFields.clone() : null;
        zipEntry.setInternalAttributes(this.getInternalAttributes());
        zipEntry.setExternalAttributes(this.getExternalAttributes());
        zipEntry.setExtraFields(this.getExtraFields());
        return zipEntry;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public ZipExtraField[] getExtraFields() {
        if (this.extraFields == null) {
            return new ZipExtraField[0];
        }
        Object[] objectArray = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(objectArray);
        return objectArray;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        return byArray != null ? byArray : new byte[]{};
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public int getPlatform() {
        return this.platform;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    public void removeExtraField(ZipShort zipShort) {
        if (this.extraFields == null) {
            this.extraFields = new Vector();
        }
        boolean bl = false;
        int n = this.extraFields.size();
        for (int i = 0; !bl && i < n; ++i) {
            if (!((ZipExtraField)this.extraFields.elementAt(i)).getHeaderId().equals(zipShort)) continue;
            this.extraFields.removeElementAt(i);
            bl = true;
        }
        if (!bl) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    @Deprecated
    public void setComprSize(long l) {
        this.setCompressedSize(l);
    }

    public void setExternalAttributes(long l) {
        this.externalAttributes = l;
    }

    @Override
    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        this.extraFields = new Vector();
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            this.extraFields.addElement(zipExtraField);
        }
        this.setExtra();
    }

    public void setInternalAttributes(int n) {
        this.internalAttributes = n;
    }

    public void setUnixMode(int n) {
        this.setExternalAttributes(n << 16 | ((n & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    protected void setName(String string) {
        this.name = string;
    }

    protected void setPlatform(int n) {
        this.platform = n;
    }
}

