/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.org.apache.tools.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import se.prediktera.map.common.org.apache.tools.zip.ZipEntry;
import se.prediktera.map.common.org.apache.tools.zip.ZipLong;
import se.prediktera.map.common.org.apache.tools.zip.ZipOutputStream;
import se.prediktera.map.common.org.apache.tools.zip.ZipShort;

public class ZipFile {
    private static final int HASH_SIZE = 509;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    private static final int NIBLET_MASK = 15;
    private static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private static final int CFH_LEN = 42;
    private static final int MIN_EOCD_SIZE = 22;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private final Hashtable entries = new Hashtable(509);
    private final Hashtable nameMap = new Hashtable(509);
    private String encoding = null;
    private final RandomAccessFile archive;

    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static Date fromDosTime(ZipLong zipLong) {
        long l = zipLong.getValue();
        return new Date(ZipFile.dosToJavaTime(l));
    }

    private static long dosToJavaTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, (int)(l >> 25 & 0x7FL) + 1980);
        calendar.set(2, (int)(l >> 21 & 0xFL) - 1);
        calendar.set(5, (int)(l >> 16) & 0x1F);
        calendar.set(11, (int)(l >> 11) & 0x1F);
        calendar.set(12, (int)(l >> 5) & 0x3F);
        calendar.set(13, (int)(l << 1) & 0x3E);
        return calendar.getTime().getTime();
    }

    public ZipFile(File file) throws IOException {
        this(file, null);
    }

    public ZipFile(File file, String string) throws IOException {
        this.encoding = string;
        this.archive = new RandomAccessFile(file, "r");
        try {
            this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData();
        }
        catch (IOException iOException) {
            try {
                this.archive.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    public ZipFile(String string) throws IOException {
        this(new File(string), null);
    }

    public ZipFile(String string, String string2) throws IOException {
        this(new File(string), string2);
    }

    public void close() throws IOException {
        this.archive.close();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Enumeration getEntries() {
        return this.entries.keys();
    }

    public ZipEntry getEntry(String string) {
        return (ZipEntry)this.nameMap.get(string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException, ZipException {
        OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(zipEntry);
        if (offsetEntry == null) {
            return null;
        }
        long l = offsetEntry.dataOffset;
        BoundedInputStream boundedInputStream = new BoundedInputStream(l, zipEntry.getCompressedSize());
        return switch (zipEntry.getMethod()) {
            case 0 -> boundedInputStream;
            case 8 -> {
                boundedInputStream.addDummy();
                yield new InflaterInputStream(boundedInputStream, new Inflater(true));
            }
            default -> throw new ZipException("Found unsupported compression method " + zipEntry.getMethod());
        };
    }

    protected String getString(byte[] byArray) throws ZipException {
        if (this.encoding == null) {
            return new String(byArray);
        }
        try {
            return new String(byArray, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ZipException(unsupportedEncodingException.getMessage());
        }
    }

    private void populateFromCentralDirectory() throws IOException {
        this.positionAtCentralDirectory();
        byte[] byArray = new byte[42];
        byte[] byArray2 = new byte[4];
        this.archive.readFully(byArray2);
        long l = ZipLong.getValue(byArray2);
        long l2 = ZipLong.getValue(ZipOutputStream.CFH_SIG);
        while (l == l2) {
            this.archive.readFully(byArray);
            int n = 0;
            ZipEntry zipEntry = new ZipEntry();
            int n2 = ZipShort.getValue(byArray, n);
            n += 2;
            zipEntry.setPlatform(n2 >> 8 & 0xF);
            zipEntry.setMethod(ZipShort.getValue(byArray, n += 4));
            long l3 = ZipFile.dosToJavaTime(ZipLong.getValue(byArray, n += 2));
            zipEntry.setTime(l3);
            zipEntry.setCrc(ZipLong.getValue(byArray, n += 4));
            zipEntry.setCompressedSize(ZipLong.getValue(byArray, n += 4));
            zipEntry.setSize(ZipLong.getValue(byArray, n += 4));
            int n3 = ZipShort.getValue(byArray, n += 4);
            int n4 = ZipShort.getValue(byArray, n += 2);
            int n5 = ZipShort.getValue(byArray, n += 2);
            n += 2;
            zipEntry.setInternalAttributes(ZipShort.getValue(byArray, n += 2));
            zipEntry.setExternalAttributes(ZipLong.getValue(byArray, n += 2));
            byte[] byArray3 = new byte[n3];
            this.archive.readFully(byArray3);
            zipEntry.setName(this.getString(byArray3));
            OffsetEntry offsetEntry = new OffsetEntry();
            offsetEntry.headerOffset = ZipLong.getValue(byArray, n += 4);
            this.entries.put(zipEntry, offsetEntry);
            this.nameMap.put(zipEntry.getName(), zipEntry);
            this.archive.skipBytes(n4);
            byte[] byArray4 = new byte[n5];
            this.archive.readFully(byArray4);
            zipEntry.setComment(this.getString(byArray4));
            this.archive.readFully(byArray2);
            l = ZipLong.getValue(byArray2);
        }
    }

    private void positionAtCentralDirectory() throws IOException {
        byte[] byArray;
        boolean bl = false;
        long l = this.archive.length() - 22L;
        if (l >= 0L) {
            this.archive.seek(l);
            byArray = ZipOutputStream.EOCD_SIG;
            int n = this.archive.read();
            while (n != -1) {
                if (n == byArray[0] && (n = this.archive.read()) == byArray[1] && (n = this.archive.read()) == byArray[2] && (n = this.archive.read()) == byArray[3]) {
                    bl = true;
                    break;
                }
                this.archive.seek(--l);
                n = this.archive.read();
            }
        }
        if (!bl) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.archive.seek(l + 16L);
        byArray = new byte[4];
        this.archive.readFully(byArray);
        this.archive.seek(ZipLong.getValue(byArray));
    }

    private void resolveLocalFileHeaderData() throws IOException {
        Enumeration enumeration = this.getEntries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            OffsetEntry offsetEntry = (OffsetEntry)this.entries.get(zipEntry);
            long l = offsetEntry.headerOffset;
            this.archive.seek(l + 26L);
            byte[] byArray = new byte[2];
            this.archive.readFully(byArray);
            int n = ZipShort.getValue(byArray);
            this.archive.readFully(byArray);
            int n2 = ZipShort.getValue(byArray);
            this.archive.skipBytes(n);
            byte[] byArray2 = new byte[n2];
            this.archive.readFully(byArray2);
            zipEntry.setExtra(byArray2);
            offsetEntry.dataOffset = l + 26L + 2L + 2L + (long)n + (long)n2;
        }
    }

    private static final class OffsetEntry {
        private long headerOffset = -1L;
        private long dataOffset = -1L;

        private OffsetEntry() {
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long l, long l2) {
            this.remaining = l2;
            this.loc = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc++);
                return ZipFile.this.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    byArray[n] = 0;
                    return 1;
                }
                return -1;
            }
            if (n2 <= 0) {
                return 0;
            }
            if ((long)n2 > this.remaining) {
                n2 = (int)this.remaining;
            }
            int n3 = -1;
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc);
                n3 = ZipFile.this.archive.read(byArray, n, n2);
            }
            if (n3 > 0) {
                this.loc += (long)n3;
                this.remaining -= (long)n3;
            }
            return n3;
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }
}

