/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.performace;

import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.Logg;

public class IndexCache
extends CleanUpClass {
    long[] indexArray;
    Object[] cacheArray;
    int size;
    int start;
    int rsize;

    public static void main(String[] stringArray) {
        IndexCache indexCache = new IndexCache(10);
        for (int i = 0; i < 100; ++i) {
            indexCache.put(i, i);
            indexCache.printCache();
            if (indexCache.get(i) != null) continue;
            Logg.error("Error", new Object[0]);
        }
    }

    public IndexCache(int n) {
        this.size = n;
        this.start = 0;
        this.rsize = 0;
        this.indexArray = new long[n];
        this.cacheArray = new Object[n];
    }

    public void flushCache() {
        this.start = 0;
        this.rsize = 0;
    }

    public Object get(long l) {
        for (int i = 0; i < this.rsize; ++i) {
            int n = i + this.start;
            if (n >= this.size) {
                n -= this.size;
            }
            if (this.indexArray[n] != l) continue;
            return this.cacheArray[n];
        }
        return null;
    }

    public void printCache() {
        for (int i = 0; i < this.rsize; ++i) {
            int n = i + this.start;
            if (n >= this.size) {
                n -= this.size;
            }
            System.out.print("[" + this.indexArray[n] + "," + this.cacheArray[n].toString() + "]");
        }
        System.out.println();
    }

    public Object put(int n) {
        int n2;
        if (this.rsize == this.size) {
            n2 = this.start++;
            if (this.start == this.size) {
                this.start = 0;
            }
        } else if ((n2 = this.start + this.rsize++) >= this.size) {
            n2 -= this.size;
        }
        this.indexArray[n2] = n;
        return this.cacheArray[n2];
    }

    public void put(long l, Object object) {
        int n;
        if (this.rsize == this.size) {
            n = this.start++;
            if (this.start == this.size) {
                this.start = 0;
            }
        } else if ((n = this.start + this.rsize++) >= this.size) {
            n -= this.size;
        }
        this.indexArray[n] = l;
        this.cacheArray[n] = object;
    }

    public void replace(int n, Object object) {
        for (int i = 0; i < this.rsize; ++i) {
            int n2 = i + this.start;
            if (n2 >= this.size) {
                n2 -= this.size;
            }
            if (this.indexArray[n2] != (long)n) continue;
            this.cacheArray[n2] = object;
            break;
        }
    }

    @Override
    protected void cleanUpChild() {
        this.indexArray = null;
        this.cacheArray = null;
    }
}

