/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.performace;

import java.util.ArrayList;
import se.prediktera.map.common.performace.PerformanceInterface;

public class PerformanceManager {
    private static final ActionThread[] actionthreads = new ActionThread[1];

    public static void addAction(PerformanceInterface performanceInterface, Object[] objectArray) {
        byte by = performanceInterface.getActionType();
        if (by >= 0 && by < actionthreads.length) {
            if (actionthreads[by] == null) {
                PerformanceManager.actionthreads[by] = new ActionThread();
                actionthreads[by].start();
            }
            try {
                while (!actionthreads[by].isReady()) {
                    Thread.sleep(50L);
                }
                actionthreads[by].addAction(performanceInterface, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class ActionThread
    extends Thread {
        ArrayList<ActionRunner> actions = new ArrayList();
        boolean isready = true;

        ActionThread() {
        }

        public void addAction(PerformanceInterface performanceInterface, Object[] objectArray) {
            for (int i = 0; i < this.actions.size(); ++i) {
                ActionRunner actionRunner = this.actions.get(i);
                if (actionRunner.getId() != (long)performanceInterface.getID().intValue() || !performanceInterface.canInterrupt() || actionRunner.isActionPerformed()) continue;
                this.actions.set(i, new ActionRunner(performanceInterface, objectArray));
                actionRunner.interrupt();
                return;
            }
            this.actions.add(new ActionRunner(performanceInterface, objectArray));
        }

        public boolean isReady() {
            return this.isready;
        }

        @Override
        public void run() {
            while (true) {
                boolean bl = false;
                while (!bl) {
                    try {
                        this.isready = true;
                        ActionThread.sleep(10L);
                        this.isready = false;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = true;
                    for (ActionRunner actionRunner : this.actions) {
                        if (actionRunner.isActionPerformed()) continue;
                        this.isready = true;
                        if (!actionRunner.isAlive()) {
                            actionRunner.start();
                        }
                        bl = false;
                    }
                }
                for (ActionRunner actionRunner : this.actions) {
                    actionRunner.actionPerformed();
                }
                this.actions.clear();
            }
        }

        static class ActionRunner
        extends Thread {
            private final PerformanceInterface pi;
            private boolean actionperformed = false;
            private final Object[] arguments;

            public ActionRunner(PerformanceInterface performanceInterface, Object[] objectArray) {
                this.pi = performanceInterface;
                this.arguments = objectArray;
            }

            public void actionPerformed() {
                this.pi.actionPerformed();
            }

            @Override
            public long getId() {
                return this.pi.getID().intValue();
            }

            public boolean isActionPerformed() {
                return this.actionperformed;
            }

            @Override
            public void run() {
                try {
                    this.pi.doAction(this.arguments);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.actionperformed = true;
            }
        }
    }
}

