/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.performace;

import se.prediktera.map.common.error.ErrorHandler;

public class RuntimeInfo {
    private final Runtime runtime = Runtime.getRuntime();
    private long startTime;
    private long startUsedMem;

    private static void gc() {
        try {
            System.gc();
            Thread.sleep(100L);
            Thread.sleep(100L);
            System.gc();
            Thread.sleep(100L);
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    private static String toSizeString(long l) {
        if (l >= 0x100000L) {
            return l / 0x100000L + "M";
        }
        if (l >= 1024L) {
            return l / 1024L + "k";
        }
        return String.valueOf(l);
    }

    public RuntimeInfo() {
        this.reset();
    }

    public final void reset() {
        RuntimeInfo.gc();
        System.out.println("Starting performance calculation");
        this.startTime = System.currentTimeMillis();
        this.startUsedMem = this.runtime.totalMemory();
        RuntimeInfo.gc();
        this.startUsedMem -= this.runtime.freeMemory();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Time taken: ");
        stringBuilder.append((double)(System.currentTimeMillis() - this.startTime) / 1000.0);
        stringBuilder.append("s, memory used: ");
        RuntimeInfo.gc();
        long l = this.runtime.totalMemory();
        RuntimeInfo.gc();
        long l2 = this.runtime.freeMemory();
        stringBuilder.append(RuntimeInfo.toSizeString(l - l2 - this.startUsedMem));
        return stringBuilder.toString();
    }
}

