/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.polynom;

import se.prediktera.map.common.polynom.PolynomInterface;

public class Lexikator
implements PolynomInterface {
    protected StringBuffer curToken = new StringBuffer();
    private String polynom;
    private String polynomOrigCase;
    private int pos;
    private int size;

    public double getDouble() {
        return Double.parseDouble(this.getToken());
    }

    public String getErrorToken() {
        char c = this.tryNextChar();
        this.curToken.append(c);
        while (this.pos <= this.size && c != '\n' && c != ';') {
            this.curToken.append(this.nextChar());
            c = this.tryNextChar();
        }
        return this.curToken.toString();
    }

    public String getVariable() {
        return this.curToken.toString();
    }

    public String getPolynom() {
        return this.polynom;
    }

    public int getPos() {
        return this.pos - 1;
    }

    public final String getToken() {
        return this.curToken.toString();
    }

    public final int getTokenID() {
        char c;
        this.curToken.setLength(0);
        boolean bl = false;
        while (true) {
            if (this.pos >= this.size) {
                return 0;
            }
            c = this.polynom.charAt(this.pos);
            if (c != '\n' && c != '\r' && c != ' ' && c != '\t') break;
            ++this.pos;
        }
        if (c == '/' && this.tryChar(1) == '*') {
            int n = 1;
            ++this.pos;
            c = this.nextCharOrigCase();
            while (this.pos <= this.size) {
                if (c == '/' && this.tryChar(1) == '*') {
                    ++this.pos;
                    ++n;
                    this.curToken.append("/*");
                } else if (c == '*' && this.tryChar(1) == '/') {
                    if (--n == 0) break;
                    ++this.pos;
                    this.curToken.append("*/");
                } else {
                    this.curToken.append(c);
                }
                c = this.nextCharOrigCase();
            }
            this.pos += 2;
            return 1001;
        }
        if (c == '\"' || c == '\'') {
            char c2 = c;
            c = this.nextCharOrigCase();
            while (this.pos <= this.size && c != c2) {
                this.curToken.append(c);
                c = this.nextCharOrigCase();
            }
            if (c != c2) {
                return 1;
            }
            ++this.pos;
            return 1002;
        }
        if (Character.isDigit(c)) {
            while (this.pos < this.size && (Character.isDigit(c) || this.isDot(c))) {
                if (this.isDot(c)) {
                    if (bl) {
                        return 1;
                    }
                    bl = true;
                }
                this.curToken.append(c);
                c = this.nextChar();
            }
            if (this.isDot(this.polynom.charAt(this.pos - 1))) {
                return 2;
            }
            return 3;
        }
        if (Character.isLetter(c) || c == '$' || c == '_') {
            while (this.pos <= this.size && (Character.isLetter(c) || Character.isDigit(c) || c == '$' || c == '_')) {
                this.curToken.append(c);
                c = this.nextChar();
            }
            return this.evaluateToken();
        }
        this.curToken.setLength(1);
        this.curToken.setCharAt(0, c);
        ++this.pos;
        return c;
    }

    public final void insertString(String string) {
        this.polynom = this.polynom.substring(0, this.pos + 1) + string.toUpperCase() + this.polynom.substring(this.pos + 1);
        this.polynomOrigCase = this.polynomOrigCase.substring(0, this.pos + 1) + string + this.polynomOrigCase.substring(this.pos + 1);
        this.size = this.polynom.length();
    }

    public void setPolynom(String string) {
        this.polynom = string.toUpperCase();
        this.polynomOrigCase = string;
        this.pos = 0;
        this.size = string.length();
    }

    protected int evaluateToken() {
        String string = this.curToken.toString();
        if (string.equals("TRUE")) {
            this.curToken = new StringBuffer("1");
            return 3;
        }
        if (string.equals("FALSE")) {
            this.curToken = new StringBuffer("0");
            return 3;
        }
        if (string.equals("PI")) {
            this.curToken = new StringBuffer("3.14159265358979323846");
            return 3;
        }
        if (string.equals("SIN")) {
            return 4;
        }
        if (string.equals("COS")) {
            return 5;
        }
        if (string.equals("LOG")) {
            return 10;
        }
        if (string.equals("SQRT")) {
            return 12;
        }
        if (string.equals("EXP")) {
            return 13;
        }
        if (string.equals("OR")) {
            return 124;
        }
        if (string.equals("AND")) {
            return 38;
        }
        if (string.equals("INF")) {
            return 11;
        }
        if (this.isVariable(string)) {
            return 6;
        }
        return 2;
    }

    protected boolean isVariable(String string) {
        return string.length() >= 1;
    }

    protected boolean isDot(char c) {
        return c == ',' || c == '.';
    }

    protected char tryChar(int n) {
        int n2 = this.pos + n;
        if (n2 < this.size) {
            return this.polynom.charAt(n2);
        }
        return '\u0000';
    }

    protected char tryNextChar() {
        return this.tryChar(0);
    }

    private char nextChar() {
        if (++this.pos < this.size) {
            return this.polynom.charAt(this.pos);
        }
        return '\u0000';
    }

    private char nextCharOrigCase() {
        if (++this.pos < this.size) {
            return this.polynomOrigCase.charAt(this.pos);
        }
        return '\u0000';
    }
}

