/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.polynom;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.script.MethodCallException;

public class PolyNode
implements Cloneable {
    protected int id;
    protected int type;
    protected PolyNode left;
    protected PolyNode right;
    protected Object[] objectArray;
    private double num;
    private boolean included = false;
    private boolean isnumerical;
    private String variable;

    public PolyNode(int n, double d) {
        this.type = n;
        this.num = d;
    }

    public PolyNode(int n, char c) {
        this(String.valueOf(c));
    }

    public PolyNode(String string, double d) {
        this(string);
        this.num = d;
    }

    public PolyNode(String string) {
        this.type = 6;
        this.variable = string;
    }

    public PolyNode(PolyNode polyNode, int n, PolyNode polyNode2) {
        this.left = polyNode;
        this.type = n;
        this.right = polyNode2;
    }

    public Object clone() {
        try {
            PolyNode polyNode = (PolyNode)super.clone();
            if (this.left != null) {
                polyNode.setLeft((PolyNode)this.left.clone());
            }
            if (this.right != null) {
                polyNode.setRight((PolyNode)this.right.clone());
            }
            return polyNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ErrorHandler.logAndReportException(cloneNotSupportedException);
            return null;
        }
    }

    public int getId() {
        return this.id;
    }

    public String getVariable() {
        return this.variable;
    }

    public PolyNode getLeft() {
        return this.left;
    }

    public double getNum() {
        return this.num;
    }

    public Object[] getParam() throws MethodCallException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.createParam(arrayList);
        return arrayList.toArray();
    }

    public PolyNode getRight() {
        return this.right;
    }

    public int getType() {
        return this.type;
    }

    public Object getValue() {
        return this.num;
    }

    public String getValueStr() {
        Object object = this.getValue();
        if (object instanceof Double) {
            return NiceDataFormat.toString((Double)object);
        }
        if (object instanceof Object[]) {
            StringBuilder stringBuilder = new StringBuilder();
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(objectArray[i]);
            }
            return stringBuilder.toString();
        }
        if (object instanceof Double[]) {
            StringBuilder stringBuilder = new StringBuilder();
            Double[] doubleArray = (Double[])object;
            for (int i = 0; i < doubleArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(doubleArray[i]);
            }
            return stringBuilder.toString();
        }
        if (object instanceof double[]) {
            StringBuilder stringBuilder = new StringBuilder();
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(dArray[i]);
            }
            return stringBuilder.toString();
        }
        return String.valueOf(object);
    }

    public boolean hasError() {
        if (this.type == 2 || this.left != null && this.left.hasError()) {
            return true;
        }
        return this.right != null && this.right.hasError();
    }

    public PolyNode interval(PolyNode polyNode, PolyNode polyNode2) throws MethodCallException {
        try {
            int n = (int)polyNode.getNum();
            int n2 = (int)polyNode2.getNum() + 1;
            Double[] doubleArray = new Double[n2 - n];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = (double)n + (double)i;
            }
            this.objectArray = doubleArray;
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
        return this;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public boolean isNumerical() {
        return this.isnumerical;
    }

    public void setId(int n) {
        this.id = n;
    }

    public void setIncluded(boolean bl) {
        this.included = bl;
    }

    public void setLeft(PolyNode polyNode) {
        this.left = polyNode;
    }

    public void setNum(double d) {
        this.num = d;
        this.isnumerical = true;
    }

    public void setNumerical(boolean bl) {
        this.isnumerical = bl;
    }

    public void setRight(PolyNode polyNode) {
        this.right = polyNode;
    }

    public void setType(int n) {
        this.type = n;
    }

    protected void createParam(List<Object> list) throws MethodCallException {
        if (this.type == 44) {
            if (this.left != null) {
                this.left.createParam(list);
            }
            if (this.right != null) {
                this.right.createParam(list);
            }
        } else if (this.type == 35) {
            list.add("#");
        } else if (this.objectArray != null) {
            list.add(this.objectArray);
        } else {
            list.add(this.getValue());
        }
    }

    public String toString() {
        if (this.type == 6) {
            return "PolyNode: " + this.variable + "=" + this.num;
        }
        return super.toString();
    }
}

