/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.polynom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.polynom.Lexikator;
import se.prediktera.map.common.polynom.PolyNode;
import se.prediktera.map.common.polynom.PolynomException;
import se.prediktera.map.common.polynom.PolynomInterface;
import se.prediktera.map.main.script.MethodCallException;
import se.prediktera.map.main.script.ScriptInformationException;

public class PolynomParser
extends CleanUpClass
implements PolynomInterface {
    protected PolyNode root = null;
    protected int curId = -1;
    protected Lexikator lexikator;
    private final List<PolyNode> idList = new ArrayList<PolyNode>();

    public static void main(String[] stringArray) {
        PolynomParser polynomParser = new PolynomParser();
        try {
            PolyNode[] polyNodeArray = new PolyNode[]{new PolyNode("A1")};
            polyNodeArray[0].setNum(-1.347);
            polynomParser.parse("-1.347*-1.345+5", polyNodeArray);
            System.out.println(polynomParser.evaluateString());
            System.out.println(polynomParser.evaluateDouble());
            polynomParser.parse("A1 = 5 AND (A1 > 4 OR A1 > 6)", polyNodeArray);
            System.out.println(polynomParser.evaluateString());
            System.out.println(polynomParser.evaluateRelation());
            polynomParser.parse("(A1 = 5) OR (A1 = 10 aNd (A1 >= 4 OR A1 <= 6))", polyNodeArray);
            System.out.println(polynomParser.evaluateString());
            System.out.println(polynomParser.evaluateRelation());
        }
        catch (PolynomException polynomException) {
            ErrorHandler.logAndReportException(polynomException);
        }
    }

    public PolynomParser() {
        this.lexikator = this.createLexikator();
    }

    public PolynomParser(String string) {
        this(string, null);
    }

    public PolynomParser(String string, PolyNode[] polyNodeArray) {
        this();
        try {
            this.parse(string, polyNodeArray);
        }
        catch (PolynomException polynomException) {
            throw new RuntimeException(polynomException);
        }
    }

    public double evaluateDouble() {
        if (this.root != null) {
            return this.recExecute(this.root);
        }
        return 0.0;
    }

    public boolean evaluateRelation() {
        if (this.root != null) {
            return this.recExecute(this.root) > 0.0;
        }
        return false;
    }

    public String evaluateString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.root != null) {
            this.evaluateString(this.root, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void evaluateString(PolyNode polyNode, StringBuffer stringBuffer) {
        if (polyNode != null) {
            this.evaluateString(polyNode.getLeft(), stringBuffer);
            int n = polyNode.getType();
            if (n == 3) {
                stringBuffer.append(NiceDataFormat.toString(polyNode.getNum()));
            } else if (n == 6) {
                stringBuffer.append(polyNode.getVariable() + "(" + NiceDataFormat.toString(polyNode.getNum()) + ")");
            } else if (n == 38) {
                stringBuffer.append(" and ");
            } else if (n == 124) {
                stringBuffer.append(" or ");
            } else if (n == 93) {
                stringBuffer.append(">=");
            } else if (n == 91) {
                stringBuffer.append("<=");
            } else if (n < values.length) {
                stringBuffer.append(values[n]);
            } else {
                stringBuffer.append((char)n);
            }
            this.evaluateString(polyNode.getRight(), stringBuffer);
            if (n == 7) {
                stringBuffer.append(")");
            }
        }
    }

    public PolyNode executeFunction(PolyNode polyNode) throws MethodCallException, PolynomException, ScriptInformationException {
        return null;
    }

    public PolyNode parse(String string, PolyNode[] polyNodeArray) throws PolynomException {
        this.idList.clear();
        if (string == null || string.length() == 0) {
            throw new PolynomException("Expression is empty");
        }
        string = string.replace(">=", "]");
        string = string.replace("<=", "[");
        string = string.replace("<>", "!");
        string = string.replace("!=", "!");
        if (polyNodeArray != null) {
            this.idList.addAll(Arrays.asList(polyNodeArray));
        }
        if (polyNodeArray != null) {
            for (PolyNode polyNode : polyNodeArray) {
                polyNode.setIncluded(false);
            }
        }
        this.lexikator.setPolynom(string);
        this.curId = this.lexikator.getTokenID();
        while (this.curId != 0) {
            this.root = this.expression();
        }
        return this.root;
    }

    public String getPolynom() {
        return this.lexikator.getPolynom();
    }

    protected boolean check(int n) {
        return this.curId == n;
    }

    @Override
    protected void cleanUpChild() {
        this.root = null;
    }

    protected Lexikator createLexikator() {
        return new Lexikator();
    }

    protected boolean expect(int n) throws PolynomException {
        boolean bl = this.curId == n;
        this.curId = this.lexikator.getTokenID();
        return bl;
    }

    protected PolyNode expression() throws PolynomException {
        PolyNode polyNode = this.term();
        while (true) {
            switch (this.curId) {
                case 38: 
                case 43: 
                case 45: 
                case 124: {
                    break;
                }
                default: {
                    return polyNode;
                }
            }
            int n = this.match(this.curId);
            polyNode = new PolyNode(polyNode, n, this.term());
        }
    }

    protected PolyNode factor() throws PolynomException {
        int n = this.curId;
        switch (n) {
            case 40: {
                this.match(40);
                PolyNode polyNode = new PolyNode(null, 7, this.expression());
                this.match(41);
                return polyNode;
            }
            case 45: {
                this.match(45);
                return new PolyNode(null, 8, this.factor());
            }
            case 4: 
            case 5: 
            case 10: 
            case 12: 
            case 13: {
                this.match(n);
                this.match(40);
                PolyNode polyNode = new PolyNode(null, n, this.expression());
                this.match(41);
                return polyNode;
            }
            case 3: {
                PolyNode polyNode = new PolyNode(n, this.lexikator.getDouble());
                this.match(n);
                return polyNode;
            }
            case 11: {
                PolyNode polyNode = new PolyNode(3, Double.POSITIVE_INFINITY);
                this.match(n);
                return polyNode;
            }
            case 6: {
                PolyNode polyNode = this.getIdNode(this.lexikator.getVariable());
                polyNode.setIncluded(true);
                this.match(n);
                return polyNode;
            }
        }
        throw new PolynomException("Syntax error");
    }

    protected PolyNode getIdNode(String string) throws PolynomException {
        for (PolyNode polyNode : this.idList) {
            if (!polyNode.getVariable().equals(string)) continue;
            return polyNode;
        }
        PolyNode polyNode = new PolyNode(string);
        this.idList.add(polyNode);
        return polyNode;
    }

    public List<PolyNode> getIdList() {
        return this.idList;
    }

    protected int match(int n) throws PolynomException {
        if (this.curId != n) {
            throw new PolynomException("Missing match \"" + this.getIdName(n) + "\"");
        }
        this.curId = this.lexikator.getTokenID();
        return n;
    }

    protected final double recExecute(PolyNode polyNode) {
        switch (polyNode.getType()) {
            case 43: {
                return this.recExecute(polyNode.getLeft()) + this.recExecute(polyNode.getRight());
            }
            case 45: {
                return this.recExecute(polyNode.getLeft()) - this.recExecute(polyNode.getRight());
            }
            case 42: {
                return this.recExecute(polyNode.getLeft()) * this.recExecute(polyNode.getRight());
            }
            case 47: {
                return this.recExecute(polyNode.getLeft()) / this.recExecute(polyNode.getRight());
            }
            case 61: {
                return Double.compare(this.recExecute(polyNode.getLeft()), this.recExecute(polyNode.getRight())) == 0 ? 1.0 : 0.0;
            }
            case 33: {
                return Double.compare(this.recExecute(polyNode.getLeft()), this.recExecute(polyNode.getRight())) == 0 ? 0.0 : 1.0;
            }
            case 38: {
                return this.recExecute(polyNode.getLeft()) > 0.0 && this.recExecute(polyNode.getRight()) > 0.0 ? 1.0 : 0.0;
            }
            case 124: {
                return this.recExecute(polyNode.getLeft()) > 0.0 || this.recExecute(polyNode.getRight()) > 0.0 ? 1.0 : 0.0;
            }
            case 62: {
                return this.recExecute(polyNode.getLeft()) > this.recExecute(polyNode.getRight()) ? 1.0 : 0.0;
            }
            case 60: {
                return this.recExecute(polyNode.getLeft()) < this.recExecute(polyNode.getRight()) ? 1.0 : 0.0;
            }
            case 93: {
                return this.recExecute(polyNode.getLeft()) >= this.recExecute(polyNode.getRight()) ? 1.0 : 0.0;
            }
            case 91: {
                return this.recExecute(polyNode.getLeft()) <= this.recExecute(polyNode.getRight()) ? 1.0 : 0.0;
            }
            case 7: {
                return this.recExecute(polyNode.getRight());
            }
            case 4: {
                return Math.sin(this.recExecute(polyNode.getRight()));
            }
            case 5: {
                return Math.cos(this.recExecute(polyNode.getRight()));
            }
            case 10: {
                double d = this.recExecute(polyNode.getRight());
                if (d > 0.0) {
                    return Math.log10(d);
                }
                return 0.0;
            }
            case 12: {
                double d = this.recExecute(polyNode.getRight());
                if (d > 0.0) {
                    return Math.sqrt(d);
                }
                return 0.0;
            }
            case 13: {
                double d = this.recExecute(polyNode.getRight());
                if (d > 0.0) {
                    return Math.exp(d);
                }
                return 0.0;
            }
            case 94: {
                return Math.pow(this.recExecute(polyNode.getLeft()), this.recExecute(polyNode.getRight()));
            }
            case 37: {
                return (int)this.recExecute(polyNode.getLeft()) % (int)this.recExecute(polyNode.getRight());
            }
            case 8: {
                return -this.recExecute(polyNode.getRight());
            }
            case 3: 
            case 6: 
            case 2002: {
                return polyNode.getNum();
            }
            case 2001: {
                try {
                    PolyNode polyNode2 = this.executeFunction(polyNode);
                    if (polyNode2 != null && polyNode2.getValue() instanceof Double) {
                        return (Double)polyNode2.getValue();
                    }
                    break;
                }
                catch (Exception exception) {
                    ErrorHandler.logAndReportException(exception);
                }
            }
        }
        return 0.0;
    }

    protected PolyNode term() throws PolynomException {
        PolyNode polyNode = this.factor();
        while (true) {
            switch (this.curId) {
                case 33: 
                case 37: 
                case 42: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 91: 
                case 93: 
                case 94: {
                    break;
                }
                default: {
                    return polyNode;
                }
            }
            int n = this.match(this.curId);
            polyNode = new PolyNode(polyNode, n, this.factor());
        }
    }

    private String getIdName(int n) {
        return switch (n) {
            case 2001 -> "Method";
            case 2002 -> "Variable";
            case 2003 -> "Variable Array";
            case 2004 -> "Tag";
            case 3001 -> "If";
            case 3002 -> "While";
            case 3003 -> "Foreach";
            case 3004 -> "End";
            case 4001 -> "Expression";
            default -> String.valueOf((char)n);
        };
    }

    public PolyNode getRoot() {
        return this.root;
    }
}

