/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.progress;

import javax.swing.JLabel;

public class ProgressLabel
extends JLabel {
    private long taskStartTime;
    private int remainingSeconds = -1;
    private final boolean timeLabel;
    private String currentText;

    public ProgressLabel(boolean bl) {
        this("", bl);
    }

    public ProgressLabel(String string, boolean bl) {
        super(string);
        this.currentText = string;
        this.timeLabel = bl;
        this.reset();
    }

    public void reset() {
        this.taskStartTime = System.currentTimeMillis();
        this.remainingSeconds = -1;
    }

    @Override
    public void setText(String string) {
        this.currentText = string;
        this.setText();
    }

    public void setTimeLeft(double d) {
        if (!this.timeLabel) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.taskStartTime;
        long l3 = (long)((double)l2 / d);
        long l4 = l3 - l2;
        if (d >= 0.1) {
            this.remainingSeconds = (int)l4 / 1000;
            this.setText();
        }
    }

    private void setText() {
        if (this.remainingSeconds < 0) {
            super.setText(this.currentText);
        } else {
            super.setText("<html>" + this.currentText + "<br/><i>" + this.remainingSeconds + " seconds left</i></html>");
        }
    }
}

