/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.progress;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressPanel;
import se.prediktera.map.common.progress.SwingWorker;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;

public abstract class ProgressManagerImpl
extends CleanUpClass
implements ProgressManager {
    private static ProgressManagerImpl pManager = null;
    private ProgressManager.Result modalresult = ProgressManager.Result.notDone;
    protected Object[] arguments;
    protected ProgressPanel contentPane = new ProgressPanel(this);
    protected Dimension preferredDimension;
    private SwingWorker worker;
    private boolean isfinished = false;
    private boolean initializing = true;
    private boolean lockforchanges = false;
    private double groupstepsize;
    private double groupcurpos;
    private int groupShowIndex = 0;
    private double stepsize;
    private double curpos;
    private final int totalstep = 0;
    private int deciseconds = 10;
    private Window progressWindow;
    private boolean abortable = false;
    private final int DEFAULT_MAX_INT = 50;
    private final double DEFAULT_MAX = 50.0;
    private int maxtextlength = 50;
    private String infoText;
    private JPanel holderPanel = null;
    private final SwingTimer infoTextUpdateTimer = new SwingTimer(50, actionEvent -> {
        if (!this.lockforchanges) {
            if (this.infoText.length() > this.maxtextlength) {
                this.infoText = String.valueOf(this.infoText.subSequence(0, this.maxtextlength)) + "...";
            }
            this.contentPane.setText(this.infoText);
        }
    });

    public static ProgressManagerImpl getProgressManager() {
        return pManager;
    }

    public static Component getParentComponent() {
        Window window;
        ProgressManagerImpl progressManagerImpl = ProgressManagerImpl.getProgressManager();
        if (progressManagerImpl != null && (window = progressManagerImpl.getWindow()) != null) {
            return window;
        }
        return IniManager.getMainFrame();
    }

    public ProgressManagerImpl() {
        this(IniManager.getMainFrame(), 10000000);
    }

    public ProgressManagerImpl(JComponent jComponent) {
        this(SwingUtilities.getWindowAncestor(jComponent), 10000000);
    }

    public ProgressManagerImpl(Window window) {
        this(window, 10000000);
    }

    public ProgressManagerImpl(Window window, int n) {
        this.progressWindow = window instanceof JDialog ? new CleanUpDialog((JDialog)window, "Progress Bar", true){

            @Override
            protected void cleanUpChild() {
            }
        } : new CleanUpDialog((Frame)window, "Progress Bar", true){

            @Override
            protected void cleanUpChild() {
            }
        };
        this.init(n);
    }

    public ProgressManagerImpl(JPanel jPanel) {
        this.holderPanel = jPanel;
        this.init(10000000);
    }

    public ProgressManagerImpl(Object[] objectArray) {
        this();
        this.arguments = objectArray;
    }

    public ProgressManagerImpl(String string) {
        JFrame jFrame = new JFrame(string);
        Evince.setFrameIcons(jFrame);
        jFrame.setResizable(false);
        this.progressWindow = jFrame;
        this.init(10000000);
    }

    @Override
    public void setMaxtextlength(int n) {
        this.maxtextlength = n;
    }

    @Override
    public void abort() {
        this.modalresult = ProgressManager.Result.abort;
    }

    @Override
    public void abortButtonClicked() {
        this.modalresult = ProgressManager.Result.abort;
        this.isfinished = true;
        this.cleanUp();
    }

    @Override
    public void addDistributionInfo() {
    }

    public final void addMaximum(int n) {
        if (this.lockforchanges) {
            return;
        }
        this.addMaximumInternal(n);
    }

    @Override
    public void bringToFront() {
        if (this.progressWindow != null) {
            this.progressWindow.toFront();
        }
    }

    public abstract Object doWork();

    @Override
    public void Finish() {
        this.contentPane.stop();
        if (!this.isAborted()) {
            this.modalresult = ProgressManager.Result.ok;
        }
        this.isfinished = true;
        if (this.progressWindow != null) {
            this.cleanUp();
        }
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public ProgressPanel getContentPane() {
        return this.contentPane;
    }

    @Override
    public ProgressManager.Result getModalResults() {
        return this.modalresult;
    }

    @Override
    public Object getResult() {
        return this.worker.getValue();
    }

    @Override
    public int getTotalStep() {
        return 0;
    }

    @Override
    public Window getWindow() {
        return this.progressWindow;
    }

    public void Hide() {
        this.contentPane.stop();
        this.modalresult = ProgressManager.Result.ok;
        if (this.progressWindow != null) {
            this.progressWindow.setVisible(false);
        }
    }

    @Override
    public final void hideAnimationPanel() {
        this.contentPane.hideAnimationPanel();
    }

    @Override
    public final void incStep() {
        this.incStepInternal(1);
    }

    @Override
    public final void incStep(int n) {
        this.incStepInternal(n);
    }

    @Override
    public final void incStepGroup(int n) {
        if (!this.lockforchanges && n == 1) {
            int n2 = (int)this.groupcurpos;
            this.groupcurpos += this.groupstepsize;
            if (n2 != (int)this.groupcurpos) {
                this.contentPane.setGroupValue((int)this.groupcurpos);
                this.contentPane.setGroupString("Completed " + (int)(this.groupcurpos / 50.0 * 100.0) + " of 100 %");
            }
        }
    }

    public void invokeAndWait() {
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    @Override
    public void invokeLater() {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void invokeNow() {
        this.run();
    }

    @Override
    public void invokeNowAndWaitFinish() {
        this.run();
        try {
            while (!this.isfinished) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            ErrorHandler.logAndReportException(interruptedException);
        }
    }

    @Override
    public final boolean isAborted() {
        return this.modalresult == ProgressManager.Result.abort;
    }

    public final boolean isFinished() {
        return this.isfinished;
    }

    public boolean isGroupProgressBarVisible() {
        return this.contentPane.isGroupVisible();
    }

    @Override
    public void lockForChanges(boolean bl) {
        this.lockforchanges = bl;
        SwingUtilities.invokeLater(() -> {
            try {
                this.contentPane.setIndeterminate(bl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public void resetProgressValue() {
        if (this.lockforchanges) {
            return;
        }
        this.resetProgressValueInternal();
    }

    @Override
    public void run() {
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                Object object = ProgressManagerImpl.this.doWork();
                ProgressManagerImpl.this.isfinished = true;
                return object;
            }

            @Override
            public void finished() {
                ProgressManagerImpl.this.Finish();
            }
        };
        try {
            this.isfinished = false;
            this.worker.start();
            Thread.sleep(50L);
            for (int i = 0; !this.isfinished && (i < this.deciseconds || this.initializing); ++i) {
                Thread.sleep(50L);
            }
            if (!this.isfinished) {
                this.runInternal();
            }
        }
        catch (InterruptedException interruptedException) {
            this.Finish();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
            this.Finish();
        }
    }

    @Override
    public void setAbortable(boolean bl) {
        this.abortable = bl;
        this.contentPane.setAbortable(bl);
        Window window = this.progressWindow;
        if (window instanceof JDialog) {
            JDialog jDialog = (JDialog)window;
            if (bl) {
                jDialog.setDefaultCloseOperation(2);
            } else {
                jDialog.setDefaultCloseOperation(0);
            }
        }
    }

    @Override
    public void setArguments(Object[] objectArray) {
        this.arguments = objectArray;
    }

    @Override
    public void setDeciSeconds(int n) {
        this.deciseconds = n;
    }

    @Override
    public final int setGroupMaximumAndReset(int n) {
        if (!this.lockforchanges) {
            if (n > 0) {
                this.showGroupProgressBar(true);
                if (this.groupShowIndex == 1) {
                    this.groupcurpos = 0.0;
                    this.groupstepsize = 0.0;
                    this.contentPane.setGroupValue(0);
                    this.contentPane.setGroupString("Completed 0 of 100%");
                    this.contentPane.setGroupIndeterminate(false);
                    this.groupstepsize = 50.0 / (double)n;
                    this.contentPane.setGroupMaximum(50);
                }
            } else {
                this.showGroupProgressBar(false);
                this.contentPane.setGroupIndeterminate(true);
            }
        }
        return this.groupShowIndex;
    }

    @Override
    public void setIndeterminate(boolean bl) {
        this.contentPane.setIndeterminate(bl);
    }

    @Override
    public void setInfoText(String string) {
        if (!string.equals(this.infoText)) {
            this.infoText = string;
            this.infoTextUpdateTimer.restart();
        }
    }

    @Override
    public String getInfoText() {
        return this.infoText;
    }

    @Override
    public void setMaximumAndReset(int n) {
        this.setMaximumAndResetInternal(n, true);
    }

    public final void setMaximumAndResetDirectly(int n) {
        this.setMaximumAndResetInternal(n, false);
    }

    @Override
    public void setProgressValue(int n) {
        if (this.lockforchanges) {
            return;
        }
        this.setProgressValueInternal(n);
    }

    @Override
    public void setProgressValueDirectly(int n) {
        if (!this.lockforchanges) {
            this.contentPane.setValue(n);
        }
    }

    public void Show() {
        this.contentPane.start();
        this.modalresult = ProgressManager.Result.notDone;
        if (this.progressWindow != null) {
            try {
                this.progressWindow.setVisible(true);
            }
            catch (Throwable throwable) {
                ErrorHandler.logAndReportException(throwable);
            }
        }
    }

    @Override
    public void showGroupProgressBar(boolean bl) {
        this.groupShowIndex = bl ? ++this.groupShowIndex : --this.groupShowIndex;
        if (this.groupShowIndex <= 1) {
            this.contentPane.setGroupVisible(this.groupShowIndex != 0);
            if (this.progressWindow != null) {
                this.progressWindow.pack();
            }
        }
    }

    @Override
    public final void subMaximum(int n) {
        this.addMaximum(-n);
    }

    @Override
    protected void cleanUpChild() {
        this.arguments = null;
        this.contentPane.cleanUp();
        this.preferredDimension = null;
        if (this.progressWindow != null) {
            if (this.progressWindow instanceof CleanUpDialog) {
                if (this.progressWindow.isVisible()) {
                    this.progressWindow.setVisible(false);
                }
                ((CleanUpDialog)this.progressWindow).cleanUp();
            } else if (this.progressWindow.isVisible()) {
                this.progressWindow.setVisible(false);
            }
            this.progressWindow = null;
        }
        pManager = null;
    }

    private final void addMaximumInternal(int n) {
        if (!this.lockforchanges) {
            this.contentPane.setMaximum(this.contentPane.getMaximum() + (int)((double)n * this.stepsize));
        }
    }

    private final void incStepInternal(int n) {
        if (!this.lockforchanges) {
            int n2 = (int)this.curpos;
            this.curpos += this.stepsize * (double)n;
            if (n2 != (int)this.curpos) {
                this.contentPane.setValue((int)this.curpos);
            }
        }
    }

    protected void init(int n) {
        pManager = this;
        this.contentPane.setIndeterminate(true);
        this.contentPane.setMinimum(0);
        this.contentPane.setMaximum(n);
        this.jbInit();
        if (this.progressWindow != null) {
            this.progressWindow.pack();
            this.preferredDimension = (Dimension)this.progressWindow.getPreferredSize().clone();
            this.progressWindow.setLocationRelativeTo(null);
        }
        if (this.holderPanel != null) {
            this.holderPanel.add((Component)this.contentPane.getProgressBar(), "Center");
            this.holderPanel.revalidate();
            this.holderPanel.repaint();
        }
        this.initializing = false;
    }

    private void jbInit() {
        this.contentPane.setGroupVisible(false);
        if (this.progressWindow != null) {
            if (this.progressWindow instanceof JDialog) {
                ((JDialog)this.progressWindow).setContentPane(this.contentPane);
            } else {
                ((JFrame)this.progressWindow).setContentPane(this.contentPane);
            }
        }
        this.setAbortable(false);
    }

    private void resetProgressValueInternal() {
        if (!this.lockforchanges) {
            this.curpos = 0.0;
            this.stepsize = 0.0;
            this.contentPane.setValue(0);
        }
    }

    private void runInternal() {
        this.contentPane.setAbortable(this.abortable);
        Cursor cursor = null;
        if (this.progressWindow != null) {
            cursor = this.progressWindow.getCursor();
            this.progressWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.Show();
        if (this.progressWindow != null) {
            this.progressWindow.setCursor(cursor);
        }
    }

    private void setMaximumAndResetInternal(int n, boolean bl) {
        if (!this.lockforchanges) {
            if (n > 0) {
                this.resetProgressValue();
                this.contentPane.setIndeterminate(false);
                this.stepsize = 50.0 / (double)n;
                if (bl) {
                    this.contentPane.setMaximum(50);
                } else {
                    this.contentPane.setMaximum(n);
                }
            } else {
                this.contentPane.setIndeterminate(true);
            }
        }
    }

    private void setProgressValueInternal(int n) {
        if (!this.lockforchanges) {
            int n2 = (int)this.curpos;
            this.curpos = this.stepsize * (double)n;
            if (n2 != (int)this.curpos) {
                this.contentPane.setValue((int)this.curpos);
            }
        }
    }
}

