/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.progress;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressPanelInterface;

public class ProgressPanel
extends CleanUpPanel
implements ProgressPanelInterface {
    private final ImageIcon[] progressImages = new ImageIcon[]{new ImageIcon(ProgressManager.class.getResource("images/loader-0.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-1.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-2.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-3.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-4.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-5.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-6.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-7.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-8.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-9.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-10.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-11.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-12.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-13.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-14.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-15.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-16.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-17.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-18.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-19.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-20.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-21.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-22.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-23.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-24.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-25.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-26.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-27.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-28.png")), new ImageIcon(ProgressManager.class.getResource("images/loader-29.png"))};
    private final AnimPanel animPanel = new AnimPanel();
    private final ProgressManager pManager;
    private JButton abortButton;
    private JPanel animationPanel;
    private JPanel centerPanel;
    private JProgressBar groupProgressBar;
    private JLabel labelInfo;
    private JProgressBar progressBar;
    private JPanel southPanel;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        ProgressPanel progressPanel = new ProgressPanel(null);
        progressPanel.setTouchScreen(Color.black);
        jFrame.getContentPane().add(progressPanel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public ProgressPanel(ProgressManager progressManager) {
        this.pManager = progressManager;
        this.initComponents();
        this.animationPanel.add((Component)this.animPanel, "Center");
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void hideAnimationPanel() {
        this.animPanel.setVisible(false);
    }

    public boolean isGroupVisible() {
        return this.groupProgressBar.isVisible();
    }

    public void setAbortable(boolean bl) {
        this.abortButton.setEnabled(bl);
    }

    public void setGroupIndeterminate(boolean bl) {
        this.groupProgressBar.setIndeterminate(bl);
    }

    public void setGroupMaximum(int n) {
        this.groupProgressBar.setMaximum(n);
    }

    public void setGroupString(String string) {
        this.groupProgressBar.setString(string);
    }

    public void setGroupValue(int n) {
        this.groupProgressBar.setValue(n);
    }

    public void setGroupVisible(boolean bl) {
        this.groupProgressBar.setVisible(bl);
    }

    public void setIndeterminate(boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    public void setMaximum(int n) {
        this.progressBar.setMaximum(n);
    }

    public void setMinimum(int n) {
        this.progressBar.setMinimum(n);
    }

    public void setText(String string) {
        this.labelInfo.setText(string);
    }

    @Override
    public void setTouchScreen(Color color) {
        this.setBackground(color);
        this.centerPanel.setBackground(color);
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.southPanel.setBackground(color);
        this.southPanel.setBorder(BorderFactory.createEmptyBorder());
        Font font = this.labelInfo.getFont();
        this.abortButton.setVisible(false);
        this.abortButton.setBackground(color);
        this.abortButton.setForeground(Color.white);
        this.abortButton.setMinimumSize(new Dimension(80, 40));
        this.abortButton.setPreferredSize(new Dimension(80, 40));
        this.abortButton.setMargin(new Insets(0, 0, 0, 0));
        this.abortButton.setFont(new Font(font.getName(), font.getStyle(), 18));
        this.animationPanel.setBackground(color);
        this.animPanel.setBackground(color);
        this.labelInfo.setForeground(new Color(150, 150, 150));
        this.labelInfo.setFont(new Font(font.getName(), font.getStyle(), 18));
        this.progressBar.setMinimumSize(new Dimension(10, 32));
        this.progressBar.setPreferredSize(new Dimension(300, 32));
        this.groupProgressBar.setMinimumSize(new Dimension(10, 32));
        this.groupProgressBar.setPreferredSize(new Dimension(300, 32));
    }

    public void setValue(int n) {
        this.progressBar.setValue(n);
    }

    public void start() {
        this.animPanel.start();
    }

    public void stop() {
        if (this.animPanel != null) {
            this.animPanel.stop();
        }
    }

    @Override
    protected void cleanUpChild() {
        this.stop();
    }

    private void abortButtonActionPerformed(ActionEvent actionEvent) {
        this.pManager.abortButtonClicked();
    }

    private void initComponents() {
        this.southPanel = new JPanel();
        this.abortButton = new JButton();
        this.centerPanel = new JPanel();
        this.groupProgressBar = new JProgressBar();
        this.progressBar = new JProgressBar();
        this.animationPanel = new JPanel();
        this.labelInfo = new JLabel();
        this.setLayout(new GridBagLayout());
        this.southPanel.setLayout(new GridBagLayout());
        this.abortButton.setText("Abort");
        this.abortButton.setMinimumSize(new Dimension(74, 27));
        this.abortButton.setPreferredSize(new Dimension(74, 27));
        this.abortButton.addActionListener(actionEvent -> this.abortButtonActionPerformed(actionEvent));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.southPanel.add((Component)this.abortButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.southPanel, gridBagConstraints);
        this.centerPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.centerPanel.setLayout(new GridBagLayout());
        this.groupProgressBar.setMinimumSize(new Dimension(10, 16));
        this.groupProgressBar.setPreferredSize(new Dimension(300, 16));
        this.groupProgressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.centerPanel.add((Component)this.groupProgressBar, gridBagConstraints);
        this.progressBar.setMinimumSize(new Dimension(10, 16));
        this.progressBar.setPreferredSize(new Dimension(300, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.centerPanel.add((Component)this.progressBar, gridBagConstraints);
        this.animationPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.centerPanel.add((Component)this.animationPanel, gridBagConstraints);
        this.labelInfo.setText("Running...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.centerPanel.add((Component)this.labelInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.centerPanel, gridBagConstraints);
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private class AnimPanel
    extends JPanel
    implements ActionListener {
        private final Timer timer;
        private int index = 0;

        public AnimPanel() {
            this.setPreferredSize(new Dimension(50, 50));
            this.timer = new Timer(20, this);
            this.timer.setInitialDelay(0);
            this.timer.setCoalesce(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.repaint();
            this.index = (this.index + 1) % 29;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = this.getWidth() / 2 - ProgressPanel.this.progressImages[this.index].getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - ProgressPanel.this.progressImages[this.index].getIconHeight() / 2;
            ProgressPanel.this.progressImages[this.index].paintIcon(this, graphics, n, n2);
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }
    }
}

