/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.progress;

import javax.swing.SwingUtilities;
import se.prediktera.map.common.error.ErrorHandler;

public abstract class SwingWorker {
    private Object value;
    private final Thread thread;

    public SwingWorker() {
        Runnable runnable = () -> this.finished();
        this.thread = new Thread(() -> {
            try {
                this.setValue(this.construct());
            }
            catch (Exception exception) {
                ErrorHandler.logAndShowEvinceErrorDialogForException(exception);
            }
            SwingUtilities.invokeLater(runnable);
        }, "SwingWorker");
    }

    public abstract Object construct();

    public void finished() {
    }

    public Object get() {
        while (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public void interrupt() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void start() {
        if (this.thread != null) {
            this.thread.start();
        }
    }

    public synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object object) {
        this.value = object;
    }
}

