/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.propagation;

import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressManagerImpl;
import se.prediktera.map.common.propagation.PropagationInterface;
import se.prediktera.map.data.datasettable.DataSetTable;
import se.prediktera.map.datasetcontainer.AbstractDataNode;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.datainfo.AbstractInnerColumn;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanIncExc;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnBooleanXY;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnType;
import se.prediktera.map.datasetcontainer.datainfo.VariablesInfo;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.history.AbstractHistoryNode;
import se.prediktera.map.history.HistoryInterface;
import se.prediktera.map.history.HistoryManager;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.model.AbstractModel;

public abstract class PropagationDataNode
extends AbstractDataNode
implements PropagationInterface,
HistoryInterface {
    protected HistoryManager historyManager;
    protected long duration;
    private boolean isprotected = false;
    private boolean haschanged = false;
    private boolean ismanual = true;
    private boolean propagaing = false;
    private final long timestamp;
    private final String username;
    private int deciseconds = 0;

    public PropagationDataNode(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.isprotected = mapProperty.getPropertyBoolean("locked");
        this.haschanged = mapProperty.getPropertyBoolean("hs");
        this.ismanual = mapProperty.getPropertyBoolean("manual");
        this.duration = mapProperty.getPropertyLong("dur");
        this.timestamp = mapProperty.getPropertyLong("ts");
        this.username = mapProperty.getPropertyStringUTF("un");
        this.historyManager = (HistoryManager)mapProperty.resolveNodeFromName(randomInputStream, "hm");
    }

    public PropagationDataNode(String string, boolean bl) {
        super(string);
        this.ismanual = bl;
        this.timestamp = System.currentTimeMillis();
        this.username = IniManager.getUsername();
        this.historyManager = new HistoryManager();
        this.addTreeNode(this.historyManager);
    }

    @Override
    public void doUpdate(ProgressManager progressManager) {
        if (!this.isprotected && this.haschanged) {
            boolean bl = this.existsYClassVariable();
            boolean bl2 = this.existsYDataVariable();
            boolean bl3 = this.modelWithNameExists("PLS Model");
            boolean bl4 = this.modelWithNameExists("PLS-DA Model");
            if (bl && bl2) {
                JOptionPane.showMessageDialog(null, "Y-variables from Data and from Class cannot co-exist.\n Please change and apply changes again!");
                this.enableApplyChangesButton();
                return;
            }
            if (bl4 && !bl) {
                JOptionPane.showMessageDialog(null, "Cannot update PLS-DA model without Y dummy variables!");
                this.enableApplyChangesButton();
                return;
            }
            if (bl3 && !bl2) {
                JOptionPane.showMessageDialog(null, "Cannot update PLS model without Y Data!");
                this.enableApplyChangesButton();
                return;
            }
            if (!bl && !bl2 && (bl3 || bl4)) {
                JOptionPane.showMessageDialog(null, "Cannot remove all Y-variables while a PLS or PLS-DA model exists!");
                this.enableApplyChangesButton();
                return;
            }
            if (this.dataTreeManager != null) {
                this.dataTreeManager.setProjectChanged();
            }
            if (progressManager == null) {
                progressManager = new ProgressManagerImpl(){

                    @Override
                    public Object doWork() {
                        this.setInfoText("Applying changes");
                        PropagationDataNode.this.haschanged = false;
                        PropagationDataNode.this.propagaing = true;
                        PropagationDataNode.this.doUpdateLocal(this);
                        PropagationDataNode.this.propagaing = false;
                        return null;
                    }
                };
                progressManager.setDeciSeconds(this.deciseconds);
                SwingUtilities.invokeLater(progressManager);
            } else {
                this.haschanged = false;
                this.propagaing = true;
                this.doUpdateLocal(progressManager);
                this.propagaing = false;
            }
        }
    }

    @Override
    public String getDescription() {
        return "Created";
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public List getHistory() {
        if (this.historyManager != null) {
            return this.historyManager.getEdits();
        }
        return null;
    }

    @Override
    public String getScript() {
        return null;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getToolTipText() {
        return this.toString();
    }

    @Override
    public String getUniqueName() {
        return this.getScriptName() + (this.getUniqueIndex() + 1);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean hasChanged() {
        return this.haschanged;
    }

    @Override
    public boolean isManual() {
        return this.ismanual;
    }

    @Override
    public boolean isProtected() {
        return this.isprotected;
    }

    public void postEdit(AbstractHistoryNode abstractHistoryNode) {
        if (this.historyManager != null) {
            this.historyManager.postEdit(abstractHistoryNode);
        }
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        super.SavePropertyLocal(randomOutputStream);
        randomOutputStream.writePropertyBoolean("locked", this.isprotected);
        randomOutputStream.writePropertyBoolean("hs", this.haschanged);
        randomOutputStream.writePropertyBoolean("manual", this.ismanual);
        randomOutputStream.writePropertyLong("ts", this.timestamp);
        randomOutputStream.writePropertyStringUTF("un", this.username);
        randomOutputStream.writePropertyLong("dur", this.duration);
        randomOutputStream.writePropertyNode("hm", this.historyManager);
    }

    public void setChanged() {
        this.setChanged(null);
    }

    @Override
    public void setChanged(ProgressManager progressManager) {
        if (!this.propagaing) {
            if (this.dataTreeManager != null) {
                this.dataTreeManager.setProjectChanged();
            }
            this.haschanged = true;
            if (!this.ismanual) {
                this.doUpdate(progressManager);
            }
            DataTreeEvent dataTreeEvent = new DataTreeEvent((Object)this, (DataTreeInterface)this, 4);
            this.triggerPropertyEvent(dataTreeEvent);
            dataTreeEvent.cleanUp();
        }
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    @Override
    public void setManual(ProgressManager progressManager, boolean bl) {
        this.setManual(progressManager, bl, !bl);
    }

    public void setManual(ProgressManager progressManager, boolean bl, boolean bl2) {
        this.ismanual = bl;
        if (bl2) {
            this.doUpdate(progressManager);
            DataTreeEvent dataTreeEvent = new DataTreeEvent((Object)this, this);
            this.triggerPropertyEvent(dataTreeEvent);
            dataTreeEvent.cleanUp();
        }
    }

    @Override
    public void setProtected(boolean bl) {
        this.setProtected(bl, null);
    }

    public void setProtected(boolean bl, ProgressManager progressManager) {
        if (this.isprotected != bl) {
            if (bl) {
                this.doUpdate(progressManager);
            }
            this.isprotected = bl;
            this.setProtectedLocal(progressManager, bl);
            DataTreeEvent dataTreeEvent = new DataTreeEvent((Object)this, this);
            this.triggerPropertyEvent(dataTreeEvent);
            dataTreeEvent.cleanUp();
        }
    }

    protected abstract void doUpdateLocal(ProgressManager var1);

    protected int getDeciseconds() {
        return this.deciseconds;
    }

    protected abstract String getScriptName();

    protected boolean isPropagating() {
        return this.propagaing;
    }

    protected void setDeciseconds(int n) {
        this.deciseconds = n;
    }

    protected abstract void setProtectedLocal(ProgressManager var1, boolean var2);

    private void enableApplyChangesButton() {
        try {
            AbstractWindow abstractWindow = this.dataTreeManager.getProject().getData_GUI().getCurrentWindow();
            if (abstractWindow instanceof DataSetTable) {
                ((DataSetTable)abstractWindow).getPropagationProperties().getToolbar().enableApplyChangesButton();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean existsYClassVariable() {
        return this.existsYFromType("Category");
    }

    private boolean existsYDataVariable() {
        return this.existsYFromType("Data") || this.existsYFromType("Added data");
    }

    private boolean existsYFromType(String string) {
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof VariablesInfo)) continue;
            VariablesInfo variablesInfo = (VariablesInfo)dataTreeInterface;
            InnerColumnBooleanIncExc innerColumnBooleanIncExc = (InnerColumnBooleanIncExc)this.getColumnWithName(variablesInfo, "Inc/Exc");
            InnerColumnBooleanXY innerColumnBooleanXY = (InnerColumnBooleanXY)this.getColumnWithName(variablesInfo, "X/Y");
            InnerColumnType innerColumnType = (InnerColumnType)this.getColumnWithName(variablesInfo, "Datatype");
            if (innerColumnBooleanXY == null || innerColumnType == null || innerColumnBooleanIncExc == null) {
                return false;
            }
            int n2 = innerColumnType.getSize();
            for (int j = 0; j < n2; ++j) {
                if (!((Boolean)innerColumnBooleanIncExc.getValue(j)).booleanValue() || ((Boolean)innerColumnBooleanXY.getValue(j)).booleanValue() || !innerColumnType.getValue(j).equals(string)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private AbstractInnerColumn getColumnWithName(VariablesInfo variablesInfo, String string) {
        for (int i = 0; i < variablesInfo.getAllColumnCount(); ++i) {
            AbstractInnerColumn abstractInnerColumn = variablesInfo.getAllInnerColumn(i);
            if (abstractInnerColumn == null || !abstractInnerColumn.toString().equals(string)) continue;
            return abstractInnerColumn;
        }
        return null;
    }

    private boolean modelWithNameExists(String string) {
        int n = this.getTreeNodeCount();
        for (int i = 0; i < n; ++i) {
            DataTreeInterface dataTreeInterface = this.getTreeNodeAt(i);
            if (!(dataTreeInterface instanceof AbstractModel) || !((AbstractModel)dataTreeInterface).toString().equals(string)) continue;
            return true;
        }
        return false;
    }
}

