/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.propagation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.propagation.PropagationInterface;
import se.prediktera.map.common.propagation.PropagationToolbar;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.wizard.AbstractInit;

public class PropagationProperties
extends CleanUpPanel {
    private final JCheckBox protectDataCheckBox = new JCheckBox("Protect DataSet");
    private final JRadioButton radioPByManual = new JRadioButton("Manually");
    private final JRadioButton radioPByAutomatic = new JRadioButton("Automatically");
    private AbstractInit abstractInit;
    private PropagationToolbar propagationToolbar;
    private PropagationInterface propI;

    public PropagationProperties(PropagationInterface propagationInterface) {
        try {
            this.jbInit();
            this.setPropagation(propagationInterface);
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void applyChanges() {
        this.propI.setProtected(this.protectDataCheckBox.isSelected());
        this.propI.setManual(null, this.radioPByManual.isSelected());
    }

    public void beginWizard(AbstractInit abstractInit) {
        this.abstractInit = abstractInit;
        byte by = abstractInit.propagationFlag;
        if (by == 0) {
            this.protectDataCheckBox.setSelected(false);
            this.radioPByManual.setSelected(true);
        } else {
            this.protectDataCheckBox.setSelected(true);
            this.setManual(by == 1);
        }
    }

    public void doUpdate() {
        this.propI.doUpdate(null);
    }

    public byte getPropagationFlag() {
        if (!this.protectDataCheckBox.isSelected()) {
            if (this.radioPByManual.isSelected()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public PropagationToolbar getToolbar() {
        if (this.propagationToolbar == null) {
            this.propagationToolbar = new PropagationToolbar(this);
            this.propagationToolbar.setPropagation(this.propI);
        }
        return this.propagationToolbar;
    }

    public boolean hasInterativity() {
        return !this.protectDataCheckBox.isSelected();
    }

    public boolean isManual() {
        return this.radioPByManual.isSelected();
    }

    public void setManual(boolean bl) {
        if (bl) {
            this.radioPByManual.setSelected(true);
        } else {
            this.radioPByAutomatic.setSelected(true);
        }
    }

    public void setPropagation(PropagationInterface propagationInterface) {
        this.propI = propagationInterface;
        this.updatePanel();
    }

    public void setProtected(boolean bl) {
        this.protectDataCheckBox.setSelected(bl);
    }

    public void updatePanel() {
        if (this.propI != null) {
            this.protectDataCheckBox.setSelected(this.propI.isProtected());
            if (this.propI.isManual()) {
                this.radioPByManual.setSelected(true);
            } else {
                this.radioPByAutomatic.setSelected(true);
            }
        }
        if (this.propagationToolbar != null) {
            this.propagationToolbar.setPropagation(this.propI);
        }
    }

    @Override
    protected void cleanUpChild() {
        if (this.abstractInit != null) {
            this.abstractInit.cleanUp();
            this.abstractInit = null;
        }
        if (this.propagationToolbar != null) {
            this.propagationToolbar.cleanUp();
            this.propagationToolbar = null;
        }
        this.propI = null;
    }

    private void jbInit() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Options"));
        this.protectDataCheckBox.setFont(new Font("Dialog", 0, 10));
        this.radioPByManual.setFont(new Font("Dialog", 0, 10));
        this.radioPByManual.setMargin(new Insets(2, 2, 2, 2));
        this.radioPByAutomatic.setFont(new Font("Dialog", 0, 10));
        this.radioPByAutomatic.setMargin(new Insets(2, 2, 2, 2));
        JLabel jLabel = new JLabel("Apply Changes");
        jLabel.setFont(new Font("Dialog", 0, 10));
        jLabel.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        this.protectDataCheckBox.setSelected(false);
        this.protectDataCheckBox.addItemListener(itemEvent -> {
            this.radioPByManual.setEnabled(!this.protectDataCheckBox.isSelected());
            this.radioPByAutomatic.setEnabled(!this.protectDataCheckBox.isSelected());
        });
        ItemListener itemListener = itemEvent -> {
            if (this.abstractInit != null && itemEvent.getStateChange() == 1) {
                this.abstractInit.propagationFlag = this.getPropagationFlag();
            }
        };
        this.protectDataCheckBox.addItemListener(itemListener);
        this.radioPByManual.setSelected(true);
        this.radioPByManual.addItemListener(itemListener);
        this.radioPByAutomatic.setToolTipText("");
        this.radioPByAutomatic.addItemListener(itemListener);
        jPanel.add((Component)this.protectDataCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 6), 0, 0));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 24, 0, 6), 0, 0));
        jPanel.add((Component)this.radioPByManual, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 36, 0, 6), 0, 0));
        jPanel.add((Component)this.radioPByAutomatic, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 36, 6, 6), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioPByManual);
        buttonGroup.add(this.radioPByAutomatic);
    }
}

