/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.propagation;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.propagation.PropagationInterface;
import se.prediktera.map.common.propagation.PropagationProperties;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButton;
import se.prediktera.map.common.swing.flat.JFlatToggleButtonComboBox;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetEvent;
import se.prediktera.map.datasetcontainer.dataset.event.DataSetListener;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.datasetcontainer.event.DataTreeListener;
import se.prediktera.map.main.GlobalMessageInterface;
import se.prediktera.map.main.Main_GUI;

public class PropagationToolbar
extends CleanUpToolBar
implements GlobalMessageInterface {
    private final JFlatToggleButton lockButton = new JFlatToggleButton();
    private final JFlatButton propagateButton = new JFlatButton();
    private PropagationProperties properties;
    private PropagationInterface propI;
    private final PropertyChanged propertyChanged = new PropertyChanged();

    public PropagationToolbar(PropagationProperties propagationProperties) {
        this.properties = propagationProperties;
        this.lockButton.setToolTipText("Protect DataSet");
        this.lockButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/unlock.png")));
        this.lockButton.addActionListener(actionEvent -> {
            this.properties.setProtected(this.lockButton.isSelected());
            this.properties.applyChanges();
        });
        this.propagateButton.setToolTipText("Apply Changes");
        this.propagateButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/update.png")));
        this.propagateButton.addActionListener(actionEvent -> {
            this.propagateButton.setEnabled(false);
            this.properties.doUpdate();
        });
        this.propagateButton.setEnabled(false);
        JFlatToggleButton jFlatToggleButton = new JFlatToggleButton();
        jFlatToggleButton.setToolTipText("Manual");
        jFlatToggleButton.setSelected(this.properties.isManual());
        JFlatToggleButton jFlatToggleButton2 = new JFlatToggleButton();
        jFlatToggleButton2.setToolTipText("Automatic");
        jFlatToggleButton2.setSelected(!this.properties.isManual());
        jFlatToggleButton.addActionListener(actionEvent -> {
            this.properties.setManual(true);
            this.properties.applyChanges();
        });
        jFlatToggleButton2.addActionListener(actionEvent -> {
            this.properties.setManual(false);
            this.properties.applyChanges();
        });
        JFlatToggleButtonComboBox jFlatToggleButtonComboBox = new JFlatToggleButtonComboBox();
        jFlatToggleButtonComboBox.setButtonGroup(new ButtonGroup());
        jFlatToggleButtonComboBox.addButton(jFlatToggleButton);
        jFlatToggleButtonComboBox.addButton(jFlatToggleButton2);
        jFlatToggleButtonComboBox.setToolTipText("Apply Changes Mode");
        jFlatToggleButtonComboBox.setVisible(false);
        this.addSeparator();
        this.setBorder(null);
        this.setFloatable(false);
        this.add(this.lockButton);
        this.add(this.propagateButton);
        this.add((Component)jFlatToggleButtonComboBox, null);
    }

    public void enableApplyChangesButton() {
        this.propagateButton.setEnabled(true);
    }

    public void setPropagation(PropagationInterface propagationInterface) {
        if (this.propI != null && this.propI != propagationInterface) {
            this.propI.removeDataTreeChangeListener(this.propertyChanged);
        }
        this.propI = propagationInterface;
        if (propagationInterface == null) {
            this.lockButton.setEnabled(false);
            this.propagateButton.setEnabled(false);
        } else {
            this.lockButton.setEnabled(true);
            this.propagateButton.setEnabled(!propagationInterface.isProtected() && propagationInterface.hasChanged());
            if (propagationInterface.isProtected()) {
                this.lockButton.setToolTipText("Unprotect DataSet");
                this.lockButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/lock.png")));
            } else {
                this.lockButton.setToolTipText("Protect DataSet");
                this.lockButton.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/unlock.png")));
            }
            this.lockButton.setSelected(propagationInterface.isProtected());
            propagationInterface.addDataTreeChangeListener(this.propertyChanged);
        }
    }

    @Override
    protected void cleanUpChild() {
        this.properties = null;
        if (this.propI != null) {
            this.propI.removeDataTreeChangeListener(this.propertyChanged);
            this.propI = null;
        }
    }

    class PropertyChanged
    implements DataTreeListener,
    DataSetListener {
        PropertyChanged() {
        }

        @Override
        public void dataSetChanged(DataSetEvent dataSetEvent) {
            PropagationToolbar.this.setPropagation(PropagationToolbar.this.propI);
        }

        @Override
        public void dataSetPurged(DataSetEvent dataSetEvent) {
        }

        @Override
        public void eventFinished(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        }

        @Override
        public void propertyChanged(DataTreeEvent dataTreeEvent) {
            PropagationToolbar.this.setPropagation(PropagationToolbar.this.propI);
        }
    }
}

