/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.resource;

import com.jogamp.opengl.util.texture.TextureData;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.swing.ImageIcon;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomInputStream;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.datasetcontainer.DataTreeMemoryClass;

public class ImageResource
extends DataTreeMemoryClass {
    private static int[][] cursor_maximum = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private BufferedImage image;
    private final TextureData glImage = null;
    private boolean singlecolor = true;

    public static boolean makeTransparent(BufferedImage bufferedImage, Color color, Color color2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        float[] fArray = ImageResource.createFloatColor(color);
        float[] fArray2 = new float[4];
        float[] fArray3 = ImageResource.createFloatColor(color2);
        int n3 = -1;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                writableRaster.getPixel(i, j, fArray2);
                if (ImageResource.isTransparentColor(fArray, fArray2)) {
                    fArray2[3] = 0.0f;
                    writableRaster.setPixel(i, j, fArray2);
                    continue;
                }
                if (fArray3 == null) continue;
                boolean bl2 = false;
                for (int[] nArray : cursor_maximum) {
                    int n4 = i + nArray[0];
                    int n5 = j + nArray[1];
                    if (n4 >= 0 && n4 < n && n5 >= 0 && n5 < n2 && !ImageResource.isTransparentColor(fArray, writableRaster.getPixel(n4, n5, fArray2))) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    writableRaster.setPixel(i, j, fArray3);
                    continue;
                }
                int n6 = 0;
                for (float f : fArray2) {
                    n6 = (int)((float)n6 + f);
                }
                if (n3 == n6) continue;
                if (n3 >= 0) {
                    bl = false;
                }
                n3 = n6;
            }
        }
        return bl;
    }

    private static float[] createFloatColor(Color color) {
        if (color != null) {
            return new float[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
        }
        return null;
    }

    private static boolean isTransparentColor(float[] fArray, float[] fArray2) {
        for (int i = 0; i < 3; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    public ImageResource(BufferedImage bufferedImage, String string) {
        super(string);
        this.image = bufferedImage;
    }

    public ImageResource(Image image, String string) {
        super(string);
        this.image = this.toBufferedImage(image);
        this.singlecolor = this.makeTransparent(Color.white, Color.black);
    }

    public ImageResource(ImageIcon imageIcon, String string) {
        super(string);
        this.image = this.toBufferedImage(imageIcon.getImage());
    }

    public ImageResource(RandomInputStream randomInputStream, MapProperty mapProperty) throws IOException {
        super(randomInputStream, mapProperty);
        this.singlecolor = mapProperty.getPropertyBoolean("sc", true);
    }

    @Override
    public void ClearDataLocal() throws IOException {
        this.image = null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public void draw(Graphics graphics) {
        this.checkAndLoadIntoMemory();
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void draw(Graphics graphics, BufferedImage bufferedImage, int n) {
        this.draw(graphics, bufferedImage, n, n, false);
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.draw(graphics, this.image, n, n2, false);
    }

    public BufferedImage getChangedColor(Color color, boolean bl) {
        if (this.image != null && this.singlecolor) {
            int n = this.image.getWidth();
            int n2 = this.image.getHeight();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            WritableRaster writableRaster = this.image.getRaster();
            WritableRaster writableRaster2 = bufferedImage.getRaster();
            float[] fArray = ImageResource.createFloatColor(color);
            float[] fArray2 = new float[4];
            float[] fArray3 = new float[4];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    boolean bl2 = false;
                    writableRaster.getPixel(i, j, fArray2);
                    if (fArray2[3] > 0.0f) {
                        bl2 = true;
                        if (bl) {
                            for (int[] nArray : cursor_maximum) {
                                int n3 = i + nArray[0];
                                int n4 = j + nArray[1];
                                if (n3 >= 0 && n3 < n && n4 >= 0 && n4 < n2 && writableRaster.getPixel(n3, n4, fArray3)[3] != 0.0f) continue;
                                bl2 = false;
                                break;
                            }
                        }
                    }
                    if (bl2) {
                        writableRaster2.setPixel(i, j, fArray);
                        continue;
                    }
                    writableRaster2.setPixel(i, j, fArray2);
                }
            }
            return bufferedImage;
        }
        return this.image;
    }

    public int getHeight() {
        this.checkAndLoadIntoMemory();
        return this.image.getHeight();
    }

    @Override
    public ImageIcon getIcon(byte by) {
        return null;
    }

    public BufferedImage getImage() {
        this.checkAndLoadIntoMemory();
        return this.image;
    }

    @Override
    public byte getNodeType() {
        return 0;
    }

    public TextureData getTextureGL() {
        this.checkAndLoadIntoMemory();
        if (this.glImage == null) {
            // empty if block
        }
        return this.glImage;
    }

    @Override
    public byte getTreeType() {
        return 5;
    }

    public int getWidth() {
        this.checkAndLoadIntoMemory();
        return this.image.getWidth();
    }

    @Override
    public boolean isSupportClearMemory() {
        return true;
    }

    @Override
    public void LoadDataLocal(RandomInputStream randomInputStream) throws IOException {
        short s;
        int n = (int)randomInputStream.ReadBlockDouble();
        int n2 = (int)randomInputStream.ReadBlockDouble();
        this.image = new BufferedImage(n, n2, 2);
        WritableRaster writableRaster = this.image.getRaster();
        int[] nArray = new int[4];
        while ((s = randomInputStream.ReadBlockShort()) >= 0) {
            short s2 = randomInputStream.ReadBlockShort();
            int n3 = randomInputStream.ReadBlockInt();
            nArray[0] = n3 >> 16 & 0xFF;
            nArray[1] = n3 >> 8 & 0xFF;
            nArray[2] = n3 & 0xFF;
            nArray[3] = n3 >> 24 & 0xFF;
            writableRaster.setPixel((int)s, (int)s2, nArray);
        }
    }

    public boolean makeTransparent(Color color, Color color2) {
        this.checkAndLoadIntoMemory();
        return ImageResource.makeTransparent(this.image, color, color2);
    }

    public void PurgeChildLocal() {
    }

    @Override
    public void SaveDataLocal(RandomOutputStream randomOutputStream) throws IOException {
        short s = this.image.getWidth();
        short s2 = this.image.getHeight();
        randomOutputStream.WriteBlockDouble(s);
        randomOutputStream.WriteBlockDouble(s2);
        for (short s3 = 0; s3 < s; s3 = (short)((short)(s3 + 1))) {
            for (short s4 = 0; s4 < s2; s4 = (short)((short)(s4 + 1))) {
                int n = this.image.getRGB(s3, s4);
                if (n == 0) continue;
                randomOutputStream.WriteBlockShort(s3);
                randomOutputStream.WriteBlockShort(s4);
                randomOutputStream.WriteBlockInt(n);
            }
        }
        randomOutputStream.WriteBlockShort((short)-1);
    }

    @Override
    public void SavePropertyLocal(RandomOutputStream randomOutputStream) throws IOException {
        randomOutputStream.writePropertyBoolean("sc", this.singlecolor);
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        ResourceNode resourceNode = (ResourceNode)this.getTreeParent();
        if (resourceNode != null) {
            resourceNode.triggerRenameEvent(this);
        }
    }

    private void draw(Graphics graphics, BufferedImage bufferedImage, int n, int n2, boolean bl) {
        this.checkAndLoadIntoMemory();
        if (bufferedImage != null) {
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            double d = (double)n / (double)n3;
            double d2 = (double)n2 / (double)n4;
            double d3 = Math.min(d, d2);
            n3 = (int)((double)n3 * d3);
            n4 = (int)((double)n4 * d3);
            graphics.drawImage(bufferedImage, n / 2 - n3 / 2, n2 / 2 - n4 / 2, n3, n4, null);
            if (bl) {
                graphics.setColor(Color.black);
                graphics.drawRect(n / 2 - n3 / 2, n2 / 2 - n4 / 2, n3 - 1, n4 - 1);
            }
        }
    }

    private boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    private BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = this.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

