/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.resource;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import se.prediktera.map.com.bitmap.BmpDecoder;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.resource.ImageResource;
import se.prediktera.map.common.resource.ResourceNode;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.datasetcontainer.DataContainer;

public class ResourceManager
extends CleanUpDialog {
    private final JList resourceList = new JList();
    private final PreviewPanel previewPanel = new PreviewPanel();
    private ResourceNode resourceContainer;
    private DataContainer rootNode;

    public static ImageResource getEmptyResource() {
        BufferedImage bufferedImage = new BufferedImage(50, 50, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 49, 49);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, 49, 49);
        BasicStroke basicStroke = new BasicStroke(5.0f, 0, 0, 10.0f);
        graphics2D.setColor(Color.red);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawLine(10, 10, 40, 40);
        graphics2D.drawLine(40, 10, 10, 40);
        graphics2D.dispose();
        return new ImageResource(bufferedImage, "Empty");
    }

    public static ImageResource loadImage(File file) throws IOException {
        return ResourceManager.loadImage(file, -1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageResource loadImage(File file, int n, boolean bl) throws IOException {
        try (FileInputStream fileInputStream = null;){
            Object object;
            Image image = null;
            fileInputStream = new FileInputStream(file);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(fileInputStream);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext() && file.getName().toLowerCase().endsWith(".bmp")) {
                image = BmpDecoder.read(fileInputStream);
            }
            while (iterator.hasNext()) {
                object = iterator.next();
                ((ImageReader)object).setInput(imageInputStream);
                image = ((ImageReader)object).read(((ImageReader)object).getMinIndex());
                if (image == null) continue;
                break;
            }
            if (image != null) {
                if (n > 0) {
                    image = ResourceManager.createPictureTransparent(image, n, bl);
                }
                object = file.getName();
                object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                ImageResource imageResource = new ImageResource(image, (String)object);
                return imageResource;
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ResourceManager resourceManager = new ResourceManager(null, new DataContainer("Root", -1));
        resourceManager.setVisible(true);
    }

    private static BufferedImage createPictureTransparent(Image image, int n, boolean bl) {
        double d;
        double d2 = image.getWidth(null);
        double d3 = d2 > (d = (double)image.getHeight(null)) ? (double)n / d2 : (double)n / d;
        int n2 = n / 2 - (int)((d2 *= d3) / 2.0);
        int n3 = n / 2 - (int)((d *= d3) / 2.0);
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, n2, n3, (int)d2, (int)d, null);
        int n4 = bufferedImage.getRGB(n2, n3);
        if (bl && n4 != 0) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (bufferedImage.getRGB(i, j) != n4) continue;
                    bufferedImage.setRGB(i, j, 0);
                }
            }
        }
        return bufferedImage;
    }

    public ResourceManager(JDialog jDialog, DataContainer dataContainer) {
        super(jDialog, "Add Custom Image", true);
        this.rootNode = dataContainer;
        this.resourceContainer = (ResourceNode)dataContainer.getNodeByName("Resources");
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(null);
            if (this.resourceContainer != null) {
                this.resourceList.setListData(this.resourceContainer.toArray());
            }
            this.resourceList.addListSelectionListener(listSelectionEvent -> {
                ImageResource imageResource = (ImageResource)this.resourceList.getSelectedValue();
                this.previewPanel.setResourceImage(imageResource);
            });
            this.resourceList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 127) {
                        ResourceManager.this.deleteSelectedResource();
                    }
                }
            });
            if (this.resourceContainer != null && !this.resourceContainer.isEmpty()) {
                this.resourceList.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException(exception);
        }
    }

    public void addResource() {
        jopensaveDialog jopensaveDialog2 = this.createOpenDialog();
        if (jopensaveDialog2.openshow()) {
            try {
                File[] fileArray = jopensaveDialog2.getSelectedFiles();
                if (fileArray != null) {
                    for (File file : fileArray) {
                        ImageResource imageResource = ResourceManager.loadImage(file, 64, true);
                        if (imageResource != null) {
                            if (this.resourceContainer == null) {
                                this.resourceContainer = new ResourceNode();
                                this.rootNode.addTreeNode(this.resourceContainer);
                            }
                            this.resourceContainer.addTreeNode(imageResource);
                        }
                        this.resourceList.setListData(this.resourceContainer.toArray());
                        this.resourceList.setSelectedIndex(this.resourceContainer.getTreeNodeCount() - 1);
                    }
                }
            }
            catch (IOException iOException) {
                ErrorHandler.logAndReportException(iOException);
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        this.rootNode = null;
        this.resourceContainer = null;
    }

    private jopensaveDialog createOpenDialog() {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select Image", this);
        jopensaveDialog2.addExtension("gif", "Gif files (*.gif)");
        jopensaveDialog2.addExtension("bmp", "Bitmap files (*.bmp)");
        jopensaveDialog2.addExtension("jpg", "JPG files (*.jpg)");
        jopensaveDialog2.addExtension("png", "PNG files (*.png)");
        jopensaveDialog2.addAllSupported();
        jopensaveDialog2.setMultiSelectionEnabled(true);
        return jopensaveDialog2;
    }

    private void deleteSelectedResource() {
        int[] nArray = this.resourceList.getSelectedIndices();
        if (nArray != null) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                this.resourceContainer.removeTreeNodeAt(nArray[i]);
            }
            this.resourceList.setListData(this.resourceContainer.toArray());
            if (!this.resourceContainer.isEmpty()) {
                this.resourceList.setSelectedIndex(0);
            }
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new GridBagLayout());
        JButton jButton = new JButton("Browse");
        jButton.addActionListener(actionEvent -> this.addResource());
        JButton jButton2 = new JButton("Delete");
        jButton2.addActionListener(actionEvent -> this.deleteSelectedResource());
        JButton jButton3 = new JButton("Rename");
        jButton3.addActionListener(actionEvent -> this.renameSelectedResource());
        JButton jButton4 = new JButton("Close");
        jButton4.addActionListener(actionEvent -> this.dispose());
        this.previewPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Preview"));
        this.previewPanel.setMinimumSize(new Dimension(80, 80));
        this.previewPanel.setMaximumSize(new Dimension(80, 80));
        this.previewPanel.setPreferredSize(new Dimension(80, 80));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.resourceList);
        this.getContentPane().add((Component)jButton4, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 0, new Insets(12, 0, 12, 0), 0, 0));
        this.getContentPane().add((Component)new JSeparator(0), new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(6, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)jButton2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.getContentPane().add((Component)jButton3, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.getContentPane().add((Component)jButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)jScrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(6, 12, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.previewPanel, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 0, 12), 0, 0));
        this.getContentPane().add((Component)new JLabel("Added Images:"), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
    }

    private void renameSelectedResource() {
        String string;
        ImageResource imageResource = (ImageResource)this.resourceList.getSelectedValue();
        if (imageResource != null && (string = JOptionPane.showInputDialog(this, "Enter new name for " + String.valueOf(imageResource) + ":", imageResource.toString())) != null) {
            imageResource.setName(string);
            this.resourceList.repaint();
        }
    }

    class PreviewPanel
    extends JPanel {
        private ImageResource imageResource = null;

        PreviewPanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.imageResource != null) {
                BufferedImage bufferedImage = this.imageResource.getImage();
                int n = ((Image)bufferedImage).getWidth(null);
                int n2 = ((Image)bufferedImage).getWidth(null);
                graphics.drawImage(bufferedImage, this.getWidth() / 2 - n / 2, this.getHeight() / 2 - n2 / 2, this);
            }
        }

        public void setResourceImage(ImageResource imageResource) {
            this.imageResource = imageResource;
            this.repaint();
        }
    }
}

