/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.selection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.selection.AbstractSelectionPage;
import se.prediktera.map.common.selection.CommonSelection;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.classes.ClassSelectionPage;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.FoldMatrix;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.model.AbstractModel;

public class AbstractSelectionDialog
extends CleanUpDialog {
    public static final int REPLACE = 0;
    public static final int MERGE = 1;
    public static final int INTERSECT = 2;
    private final JButton buttonMerge = new JButton("Merge");
    private final JButton buttonIntersect = new JButton("Intersect");
    private CommonSelection commonSelection;
    private ClassSelectionPage classSelection;
    private final JTabbedPane selectionTabs = new JTabbedPane();

    public AbstractSelectionDialog(AbstractWindow abstractWindow) {
        super(IniManager.getMainFrame(), "Selection Dialog - " + String.valueOf(abstractWindow), false);
        DataSet dataSet;
        this.commonSelection = new CommonSelection(abstractWindow);
        this.jbInit();
        if (abstractWindow != null && abstractWindow.getAbstractInit() != null && (dataSet = this.getDataSet(abstractWindow)) != null) {
            this.classSelection = new ClassSelectionPage(abstractWindow, dataSet);
            this.addTab("Categories", this.classSelection);
        }
    }

    public boolean addToWindowPopup(Point point, JPopupMenu jPopupMenu) {
        return this.commonSelection.addToWindowPopup(point, jPopupMenu);
    }

    public void doInteraction(InteractionInterface interactionInterface) {
        AbstractSelectionPage abstractSelectionPage = (AbstractSelectionPage)this.selectionTabs.getSelectedComponent();
        if (abstractSelectionPage != null) {
            abstractSelectionPage.doInteraction(interactionInterface);
        }
    }

    public byte getSelectionType() {
        return this.commonSelection.getSelectionType();
    }

    public void getToolbars(Vector<JToolBar> vector) {
        vector.addElement(this.commonSelection.getSelectionToolBar());
    }

    public void showModal(AbstractWindow abstractWindow) {
        int n = this.selectionTabs.getComponentCount();
        for (int i = 0; i < n; ++i) {
            AbstractSelectionPage abstractSelectionPage = (AbstractSelectionPage)this.selectionTabs.getComponentAt(i);
            abstractSelectionPage.initPage(abstractWindow);
        }
        super.setVisible(true);
    }

    protected void addTab(String string, Component component) {
        this.selectionTabs.addTab(string, component);
    }

    @Override
    protected void cleanUpChild() {
        if (this.commonSelection != null) {
            this.commonSelection.cleanUp();
            this.commonSelection = null;
        }
        if (this.classSelection != null) {
            this.classSelection.cleanUp();
            this.classSelection = null;
        }
    }

    protected DataSet getDataSet(AbstractWindow abstractWindow) {
        DataTreeInterface dataTreeInterface = abstractWindow.getAbstractInit().getDataTreeInterface();
        if (dataTreeInterface instanceof FoldMatrix) {
            FoldMatrix foldMatrix = (FoldMatrix)dataTreeInterface;
            return this.getDataSet(foldMatrix.getReferencedMatrix());
        }
        return this.getDataSet(dataTreeInterface);
    }

    protected DataSet getDataSet(DataTreeInterface dataTreeInterface) {
        if (dataTreeInterface instanceof Case) {
            return ((Case)dataTreeInterface).getOriginalDataSet();
        }
        if (dataTreeInterface instanceof DataSet) {
            return (DataSet)dataTreeInterface;
        }
        if (dataTreeInterface == null) {
            return null;
        }
        return this.getDataSet(dataTreeInterface.getTreeParent());
    }

    protected AbstractModel getModel(AbstractWindow abstractWindow) {
        DataTreeInterface dataTreeInterface = abstractWindow.getAbstractInit().getDataTreeInterface();
        if (dataTreeInterface != null) {
            return (AbstractModel)DataTreeManager.getAncestor(dataTreeInterface, AbstractModel.class);
        }
        return null;
    }

    private void doSelect(ActionEvent actionEvent) {
        AbstractSelectionPage abstractSelectionPage = (AbstractSelectionPage)this.selectionTabs.getSelectedComponent();
        if (abstractSelectionPage != null) {
            int n = 0;
            if (actionEvent.getSource() == this.buttonMerge) {
                n = 1;
            } else if (actionEvent.getSource() == this.buttonIntersect) {
                n = 2;
            }
            abstractSelectionPage.doSelection(n);
        }
    }

    private void jbInit() {
        this.setAlwaysOnTop(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.selectionTabs, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("Select");
        jButton.setPreferredSize(new Dimension(95, 27));
        jButton.setMnemonic('R');
        jButton.addActionListener(actionEvent -> this.doSelect(actionEvent));
        this.buttonMerge.setPreferredSize(new Dimension(95, 27));
        this.buttonMerge.setMnemonic('M');
        this.buttonMerge.addActionListener(actionEvent -> this.doSelect(actionEvent));
        this.buttonIntersect.setPreferredSize(new Dimension(95, 27));
        this.buttonIntersect.setMnemonic('I');
        this.buttonIntersect.addActionListener(actionEvent -> this.doSelect(actionEvent));
        JButton jButton2 = new JButton("Close");
        jButton2.setPreferredSize(new Dimension(79, 27));
        jButton2.setMnemonic('C');
        jButton2.addActionListener(actionEvent -> this.dispose());
        JButton jButton3 = new JButton("Help");
        jButton3.setPreferredSize(new Dimension(79, 27));
        jButton3.setMnemonic('H');
        jButton3.addActionListener(actionEvent -> Main_GUI.showHelp(actionEvent));
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)this.commonSelection, "West");
        jPanel.add((Component)jButton, null);
        jPanel.add((Component)this.buttonMerge, null);
        jPanel.add((Component)this.buttonIntersect, null);
        jPanel.add((Component)jButton2, null);
        jButton.requestFocus();
    }
}

