/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.selection;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.selection.SelectionToolbar;
import se.prediktera.map.common.swing.EvinceBorderFactory;
import se.prediktera.map.main.Project_GUI;
import se.prediktera.map.main.window.AbstractWindow;

public class CommonSelection
extends CleanUpPanel
implements InteractionInterface {
    public static final byte SELECTNORMAL = 0;
    public static final byte SELECTALL = 1;
    public static final byte INVERTSELECTION = 2;
    public static final byte CLEARSELECTION = 3;
    private final JButton buttonSelectAll = new JButton("Select All");
    private final JButton buttonInvertSelection = new JButton("Invert");
    private final JButton buttonNoSelection = new JButton("Clear");
    private byte selectiontype = 0;
    private AbstractWindow window;
    private SelectionToolbar selectionToolbar = null;

    public CommonSelection(AbstractWindow abstractWindow) {
        this.window = abstractWindow;
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonSelection.this.doSelection((byte)1);
            }
        };
        this.buttonSelectAll.addActionListener(abstractAction);
        abstractWindow.registerKeyAction(KeyStroke.getKeyStroke(65, 2), abstractAction);
        this.buttonNoSelection.addActionListener(actionEvent -> this.doSelection((byte)3));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonSelection.this.doSelection((byte)2);
            }
        };
        this.buttonInvertSelection.addActionListener(abstractAction2);
        abstractWindow.registerKeyAction(KeyStroke.getKeyStroke(73, 2), abstractAction2);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(EvinceBorderFactory.createEvinceBorder("Common"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.buttonSelectAll, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)this.buttonNoSelection, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.gridy = 2;
        jPanel.add((Component)this.buttonInvertSelection, gridBagConstraints3);
        jPanel.setMaximumSize(new Dimension(1000, this.buttonSelectAll.getHeight() * 3));
        this.add(jPanel);
        this.add(Box.createVerticalGlue());
    }

    public boolean addToWindowPopup(Point point, JPopupMenu jPopupMenu) {
        CMenuItem cMenuItem = new CMenuItem("Select All", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonSelection.this.doSelection((byte)1);
            }
        };
        cMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jPopupMenu.add(cMenuItem);
        CMenuItem cMenuItem2 = new CMenuItem("Invert Selection", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonSelection.this.doSelection((byte)2);
            }
        };
        cMenuItem2.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jPopupMenu.add(cMenuItem2);
        jPopupMenu.add(new CMenuItem("Clear Selection", true){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CommonSelection.this.doSelection((byte)3);
            }
        });
        return true;
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        return false;
    }

    @Override
    public void doQuickInteraction(InteractionInterface interactionInterface, int n, int n2, int n3, int n4) {
    }

    public void doSelection(byte by) {
        Project_GUI project_GUI;
        this.selectiontype = by;
        if (this.window != null && (project_GUI = this.window.getProject_GUI()) != null) {
            project_GUI.doInteraction(this);
        }
        this.selectiontype = 0;
    }

    @Override
    public void finishInteraction() {
    }

    public InteractionArray getInteractionArray(int n) {
        return this.window.getProject_GUI().getInteractionArray(n, 0);
    }

    public JToolBar getSelectionToolBar() {
        if (this.selectionToolbar == null) {
            this.selectionToolbar = new SelectionToolbar(this);
        }
        return this.selectionToolbar;
    }

    public byte getSelectionType() {
        return this.selectiontype;
    }

    public AbstractWindow getWindow() {
        return this.window;
    }

    @Override
    public void prepareInteraction() {
        this.window.prepareInteraction();
    }

    @Override
    public void setInteractionFlag(byte by) {
    }

    @Override
    protected void cleanUpChild() {
        if (this.selectionToolbar != null) {
            this.selectionToolbar.cleanUp();
            this.selectionToolbar = null;
        }
        this.window = null;
    }
}

