/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ComponentBorder
extends TitledBorder {
    private JComponent component = null;

    public ComponentBorder(JComponent jComponent, Border border) {
        this(jComponent, border, null);
    }

    public ComponentBorder(JComponent jComponent, Border border, String string) {
        super(border, string);
        this.component = jComponent;
    }

    public ComponentBorder(JComponent jComponent, String string) {
        this(jComponent, null, string);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = this.border == null ? new Insets(0, 0, 0, 0) : this.border.getBorderInsets(component);
        insets.top = 4 + insets2.top;
        insets.right = 4 + insets2.right;
        insets.bottom = 4 + insets2.bottom;
        insets.left = 4 + insets2.left;
        if (component == null || this.component == null) {
            return insets;
        }
        int n = this.component.getPreferredSize().height;
        switch (this.titlePosition) {
            case 1: {
                insets.top += n + 2;
                break;
            }
            case 3: {
                insets.top += n + 2;
                break;
            }
            case 4: {
                insets.bottom += n + 2;
                break;
            }
            case 5: {
                insets.bottom += Math.max(n, insets2.bottom) - insets2.bottom;
                break;
            }
            case 6: {
                insets.bottom += n + 2;
                break;
            }
            default: {
                insets.top += Math.max(n, insets2.top) - insets2.top;
            }
        }
        return insets;
    }

    public Rectangle getComponentRect(Rectangle rectangle, Insets insets) {
        Dimension dimension = this.component.getPreferredSize();
        Rectangle rectangle2 = new Rectangle(0, 0, dimension.width, dimension.height);
        rectangle2.y = this.getTitlePosition(rectangle, insets, dimension);
        rectangle2.x = this.getTitleJustification(rectangle, insets, rectangle2);
        return rectangle2;
    }

    public JComponent getTitleComponent() {
        return this.component;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        Insets insets = this.border == null ? new Insets(0, 0, 0, 0) : this.border.getBorderInsets(component);
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        Insets insets2 = this.getBorderInsets(component);
        Rectangle rectangle3 = this.getComponentRect(rectangle2, insets2);
        switch (this.titlePosition) {
            case 1: {
                int n5 = rectangle3.height + 2;
                rectangle.y += n5;
                rectangle.height -= n5;
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                int n6 = insets2.bottom / 2 - insets.bottom - 2;
                rectangle.height -= n6;
                break;
            }
            case 6: {
                int n7 = rectangle3.height + 2;
                rectangle.height -= n7;
                break;
            }
            default: {
                int n8 = insets2.top / 2 - insets.top - 2;
                rectangle.y += n8;
                rectangle.height -= n8;
            }
        }
        this.border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Color color = graphics.getColor();
        graphics.setColor(component.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        graphics.setColor(color);
        this.component.repaint();
    }

    public void setTitleComponent(JComponent jComponent) {
        this.component = jComponent;
    }

    private int getTitleJustification(Rectangle rectangle, Insets insets, Rectangle rectangle2) {
        return switch (this.titleJustification) {
            case 3 -> rectangle.width - insets.right - 5 - rectangle2.width;
            case 2 -> (rectangle.width - rectangle2.width) / 2;
            default -> 5 + insets.left;
        };
    }

    private int getTitlePosition(Rectangle rectangle, Insets insets, Dimension dimension) {
        return switch (this.titlePosition) {
            case 1 -> 2;
            case 3 -> insets.top - dimension.height - 2;
            case 4 -> rectangle.height - insets.bottom + 2;
            case 5 -> rectangle.height - insets.bottom + 2 + (insets.bottom - 2 - 2 - dimension.height) / 2;
            case 6 -> rectangle.height - dimension.height - 2;
            default -> 2 + (insets.top - 2 - 2 - dimension.height) / 2;
        };
    }
}

