/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.map.common.swing.ComponentBorder;
import se.prediktera.map.common.swing.EvinceBorderFactory;

public class ComponentBorderedPanel
extends JPanel {
    protected JPanel panel;

    public ComponentBorderedPanel(JComponent jComponent) {
        super(new GridBagLayout());
        this.panel = new JPanel();
        this.init(jComponent);
    }

    public ComponentBorderedPanel(LayoutManager layoutManager, JComponent jComponent) {
        super(new GridBagLayout());
        this.panel = new JPanel(layoutManager);
        this.init(jComponent);
    }

    public void add(JComponent jComponent) {
        this.panel.add(jComponent);
    }

    public void add(JComponent jComponent, int n) {
        this.panel.add((Component)jComponent, n);
    }

    public void add(JComponent jComponent, Object object) {
        this.panel.add((Component)jComponent, object);
    }

    public void add(JComponent jComponent, Object object, int n) {
        this.panel.add(jComponent, object, n);
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        Rectangle rectangle2 = this.getComponentBorder().getComponentRect(rectangle, insets);
        this.getTitleComponent().setBounds(rectangle2);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        this.panel.setBounds(rectangle);
    }

    public ComponentBorder getComponentBorder() {
        return (ComponentBorder)this.getBorder();
    }

    public JComponent getTitleComponent() {
        return this.getComponentBorder().getTitleComponent();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.panel != null) {
            this.panel.setBackground(color);
        }
    }

    protected final void setPanelVisible(boolean bl) {
        Serializable serializable;
        if (bl) {
            serializable = new GridBagConstraints();
            ((GridBagConstraints)serializable).gridx = 0;
            ((GridBagConstraints)serializable).gridy = 0;
            ((GridBagConstraints)serializable).weightx = 1.0;
            ((GridBagConstraints)serializable).weighty = 1.0;
            ((GridBagConstraints)serializable).fill = 1;
            super.add((Component)this.panel, serializable);
        } else {
            this.remove(this.panel);
        }
        serializable = this.getParent();
        if (serializable != null) {
            ((Container)serializable).invalidate();
            ((Container)serializable).validate();
        }
    }

    private final void init(JComponent jComponent) {
        this.setBorder(EvinceBorderFactory.createEvinceBorder(jComponent));
        this.getComponentBorder().setTitleComponent(jComponent);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        super.add((Component)jComponent, gridBagConstraints);
        this.setPanelVisible(true);
    }
}

