/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import se.prediktera.map.common.swing.BlockComboListener;
import se.prediktera.map.common.swing.ComboBoxRenderer;

public class JComboBoxCell
extends JComboBox {
    public static final String SEPARATOR = "%SEPARATOR#";

    public JComboBoxCell() {
        this(false);
    }

    public JComboBoxCell(boolean bl) {
        if (bl) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(new BlockComboListener(this));
    }

    public JComboBoxCell(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(new BlockComboListener(this));
    }

    public void addSeparator() {
        this.addItem(SEPARATOR);
    }

    public void execute() {
    }

    public int getSeparatorIndex() {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object e = this.getItemAt(i);
            if (!e.toString().equals(SEPARATOR)) continue;
            return i;
        }
        return -1;
    }

    public String getWorkName() {
        return "";
    }

    public boolean isExecutable() {
        return false;
    }

    public boolean isRowSeparator(int n) {
        return this.getItemAt(n).toString().equals(SEPARATOR);
    }

    public void removeAllItemsAfterSeparator() {
        int n = -1;
        int n2 = this.getItemCount();
        for (int i = 0; i < n2; ++i) {
            Object e = this.getItemAt(i);
            if (n < 0) {
                if (!e.toString().equals(SEPARATOR)) continue;
                n = i + 1;
                continue;
            }
            this.removeItemAt(n);
        }
    }

    public void setLoweredBorder() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void setText(String string) {
    }

    public void setVector(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
    }

    @Override
    public String toString() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

