/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Main_GUI;

public class JComboButtonCell
extends CleanUpPanel {
    private final JComboBoxCell combobox;
    protected JFlatButton button = new JFlatButton();

    public JComboButtonCell() {
        this.combobox = new JComboBoxCell(true);
        this.init();
    }

    public JComboButtonCell(ComboBoxModel comboBoxModel) {
        this.combobox = new JComboBoxCell(comboBoxModel);
        this.init();
    }

    public void addActionListener(ActionListener actionListener) {
        this.button.addActionListener(actionListener);
    }

    public void addItem(Object object) {
        this.combobox.addItem(object);
    }

    public void addItemListener(ItemListener itemListener) {
        this.combobox.addItemListener(itemListener);
    }

    public void addPopupMenu(MouseAdapter mouseAdapter) {
        this.combobox.addMouseListener(mouseAdapter);
    }

    public void execute() {
        this.button.doClick();
    }

    public JComboBoxCell getComboBox() {
        return this.combobox;
    }

    public Object getItemAt(int n) {
        return this.combobox.getItemAt(n);
    }

    public int getItemCount() {
        return this.combobox.getItemCount();
    }

    public int getSelectedIndex() {
        return this.combobox.getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.combobox.getSelectedItem();
    }

    public boolean isExecutable() {
        return true;
    }

    public void removeAllItems() {
        this.combobox.removeAllItems();
    }

    public void removeItem(Object object) {
        this.combobox.removeItem(object);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.combobox.removeItemListener(itemListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setEnabledButton(bl);
        this.setEnabledComboBox(bl);
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.combobox.setModel(comboBoxModel);
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this.combobox.setRenderer(listCellRenderer);
    }

    public void setSelectedIndex(int n) {
        if (n < this.combobox.getItemCount()) {
            this.combobox.setSelectedIndex(n);
        }
    }

    public void setSelectedItem(Object object) {
        this.combobox.setSelectedItem(object);
    }

    public void setVector(Vector vector) {
        this.combobox.setVector(vector);
    }

    @Override
    protected void cleanUpChild() {
        this.combobox.setModel(new DefaultComboBoxModel());
    }

    protected void setEnabledButton(boolean bl) {
        this.button.setEnabled(bl);
    }

    protected void setEnabledComboBox(boolean bl) {
        this.combobox.setEnabled(bl && this.button.isEnabled());
    }

    private final void init() {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        int n = 16;
        int n2 = 21;
        if (Evince.touchscreen) {
            n *= 2;
            n2 *= 2;
            Font font = this.combobox.getFont();
            this.combobox.setFont(new Font(font.getName(), font.getStyle(), (int)((double)font.getSize() * 1.5)));
        }
        this.setPreferredSize(new Dimension(0, n2));
        this.button.setIcon(new ImageIcon(Main_GUI.class.getResource("icons/other/settingArrowSmall.png")));
        this.button.setPreferredSize(new Dimension(n, n2));
        this.button.setRequestFocusEnabled(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.combobox, "Center");
        this.add((Component)this.button, "East");
    }
}

