/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.swing.JButtonTextCell;
import se.prediktera.map.common.swing.specialswing.ArrowIcon;

public class JComboPopupCell
extends JButtonTextCell {
    private final MenuItemListener menuItemListener = new MenuItemListener();
    private final ArrowIcon iconRenderer;
    private JPopupMenu menu = null;
    private Object selectedobject = null;
    private Object lastselectedobject = null;
    private final Vector<ActionListener> listeners = new Vector();

    public JComboPopupCell() {
        super("", "");
        this.iconRenderer = new ArrowIcon(5, true);
        this.button.setText("");
        this.button.setIcon(this.iconRenderer);
        this.button.addActionListener(new MyActionListener());
        this.textfield.setEditable(false);
        this.textfield.addMouseListener(new MouseClick());
    }

    public void addItemListener(ActionListener actionListener) {
        if (this.menu != null && this.menu.getSubElements().length > 0) {
            CMenuItem cMenuItem = (CMenuItem)this.menu.getSubElements()[0];
            this.listeners.add(actionListener);
            this.setListener(cMenuItem, actionListener);
        }
    }

    public CMenuItem addRootItem(Object object) {
        CMenuItem cMenuItem = new CMenuItem(object);
        cMenuItem.addActionListener(this.menuItemListener);
        this.menu.add(cMenuItem);
        return cMenuItem;
    }

    public void addRootSeparator() {
        if (this.menu != null) {
            this.menu.addSeparator();
        }
    }

    public void addRootSubMenu(JMenu jMenu) {
        if (this.menu != null) {
            this.menu.add(jMenu);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.setListener(jMenu, this.listeners.elementAt(i));
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    public Object getSelectedItem() {
        return this.selectedobject;
    }

    public CMenuItem insertRootItem(Object object) {
        CMenuItem cMenuItem = new CMenuItem(object);
        cMenuItem.addActionListener(this.menuItemListener);
        this.menu.insert(cMenuItem, 0);
        return cMenuItem;
    }

    @Override
    public boolean isExecutable() {
        return false;
    }

    public void removeAllItems() {
        if (this.menu != null) {
            this.menu.removeAll();
        }
    }

    public void setListener(JMenuItem jMenuItem, ActionListener actionListener) {
        if (jMenuItem instanceof JMenu) {
            JMenu jMenu = (JMenu)jMenuItem;
            int n = jMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                this.setListener(jMenu.getItem(i), actionListener);
            }
        } else if (jMenuItem instanceof CMenuItem) {
            Object object = ((CMenuItem)jMenuItem).getObject();
            if (this.selectedobject == null || object.equals(this.lastselectedobject)) {
                this.selectedobject = object;
            }
            jMenuItem.addActionListener(actionListener);
        }
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.menu = jPopupMenu;
        if (jPopupMenu.getSubElements().length > 0) {
            this.lastselectedobject = this.selectedobject;
            this.selectedobject = null;
            this.listeners.clear();
            for (int i = 0; i < jPopupMenu.getSubElements().length; ++i) {
                JMenuItem jMenuItem = (JMenuItem)jPopupMenu.getSubElements()[i];
                this.setListener(jMenuItem, this.menuItemListener);
            }
            if (this.selectedobject != null) {
                this.setSelectedItem(this.selectedobject);
            }
        }
    }

    public void setSelectedItem(Object object) {
        this.selectedobject = object;
        if (object != null) {
            this.setText(object.toString());
        } else {
            this.setText("");
        }
        this.requestFocus();
    }

    public void showPopupMenu() {
        if (this.menu != null && !this.menu.isShowing()) {
            this.menu.show(this, 0, this.getHeight());
        }
    }

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
            JComboPopupCell.this.setSelectedItem(cMenuItem.getObject());
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboPopupCell.this.showPopupMenu();
        }
    }

    class MouseClick
    extends MouseAdapter {
        MouseClick() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JComboPopupCell.this.showPopupMenu();
        }
    }
}

