/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import se.prediktera.map.common.swing.EvinceBorderFactory;

public class JFontChooser
extends JPanel {
    private final JComboBox comboBoxFont;
    private final JComboBox comboBoxSize = new JComboBox();
    private final JCheckBox checkItalic = new JCheckBox("<html><i>Italic</i></html>");
    private final JCheckBox checkBold = new JCheckBox("<html><b>Bold</b></html>");
    private JTextComponent sampleArea = new JTextArea("Enter sample text here");
    private Font selectedFont = null;
    private static String[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    public static Font showDialog(Component component, String string, Font font, String string2) {
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        JFontChooser jFontChooser = new JFontChooser(font);
        jFontChooser.setExampleText(string2);
        if (JOptionPane.showConfirmDialog(window, jFontChooser, string, 2, -1) == 0) {
            return jFontChooser.getSelectedFont();
        }
        return font;
    }

    public JFontChooser() {
        this(UIManager.getFont("Button.font"));
    }

    public JFontChooser(Font font) {
        this(font, null);
    }

    public JFontChooser(Font font, JTextComponent jTextComponent) {
        super(new BorderLayout());
        Object object;
        this.setBorder(null);
        this.comboBoxFont = new JComboBox<String>(availableFontFamilyNames);
        for (int i = 6; i <= 40; ++i) {
            this.comboBoxSize.addItem(String.valueOf(i));
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(EvinceBorderFactory.createEvinceBorder("Font"));
        jPanel.add((Component)new JLabel("Size:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)this.comboBoxSize, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 3, 0, 0), 0, 0));
        jPanel.add((Component)this.checkItalic, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)this.checkBold, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 11, 1, new Insets(6, 6, 0, 0), 0, 0));
        this.add((Component)jPanel, "Center");
        if (jTextComponent == null) {
            object = new JPanel(new BorderLayout());
            ((JComponent)object).setBorder(EvinceBorderFactory.createEvinceBorder("Example"));
            ((Container)object).add((Component)this.sampleArea, "Center");
            this.add((Component)object, "South");
        } else {
            this.sampleArea = jTextComponent;
        }
        this.selectFont(font);
        object = actionEvent -> {
            int n = (this.checkItalic.isSelected() ? 2 : 0) | (this.checkBold.isSelected() ? 1 : 0);
            this.selectedFont = new Font((String)this.comboBoxFont.getSelectedItem(), n, this.comboBoxSize.getSelectedIndex() + 6);
            this.sampleArea.setFont(this.selectedFont);
        };
        this.comboBoxFont.addActionListener((ActionListener)object);
        this.comboBoxSize.addActionListener((ActionListener)object);
        this.checkItalic.addActionListener((ActionListener)object);
        this.checkBold.addActionListener((ActionListener)object);
    }

    public JFontChooser(JTextComponent jTextComponent) {
        this(UIManager.getFont("Button.font"), jTextComponent);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void selectFont(Font font) {
        if (font == null) {
            font = new Font("SansSerif", 1, 25);
        }
        this.comboBoxFont.setSelectedItem(font.getName());
        this.comboBoxSize.setSelectedItem(String.valueOf(font.getSize()));
        this.checkItalic.setSelected(font.isItalic());
        this.checkBold.setSelected(font.isBold());
        this.sampleArea.setFont(font);
        this.selectedFont = font;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.comboBoxSize.setEnabled(bl);
        this.checkItalic.setEnabled(bl);
        this.checkBold.setEnabled(bl);
    }

    public void setExampleText(String string) {
        this.sampleArea.setText(string);
    }

    public void setShowFontStyles(boolean bl) {
        this.checkItalic.setVisible(bl);
        this.checkBold.setVisible(bl);
    }
}

