/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;
import se.prediktera.map.common.BrowserLauncher;

public class LinkLabel
extends JLabel
implements MouseListener {
    private final ArrayList<ActionListener> actionListeners = new ArrayList();
    private String linklocation;

    public LinkLabel() {
        this("link");
    }

    public LinkLabel(String string) {
        this(string, Color.blue);
    }

    public LinkLabel(String string, Color color) {
        super(string);
        this.setForeground(color);
        this.addMouseListener(this);
        this.addActionListener(actionEvent -> {
            if (this.linklocation != null) {
                BrowserLauncher.open(this.linklocation);
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Clicked");
        this.notifyListeners(actionEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        Font font = this.getFont();
        HashMap hashMap = new HashMap(font.getAttributes());
        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.setFont(font.deriveFont(hashMap));
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Font font = this.getFont();
        HashMap hashMap = new HashMap(font.getAttributes());
        hashMap.put(TextAttribute.UNDERLINE, null);
        this.setFont(font.deriveFont(hashMap));
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void notifyListeners(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void setLinkLocation(String string) {
        this.linklocation = string;
    }
}

