/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JLabel;

public class LinkMail
extends JLabel
implements MouseListener {
    private final ArrayList<ActionListener> actionListeners = new ArrayList();
    private URI linklocation;

    public LinkMail() {
        this("link");
    }

    public LinkMail(String string) {
        super(string);
        this.setForeground(Color.blue);
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Clicked");
        this.notifyListeners(actionEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void notifyListeners(ActionEvent actionEvent) {
        for (ActionListener actionListener : this.actionListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public void setLinkLocation(URI uRI) {
        this.linklocation = uRI;
        this.addActionListener(actionEvent -> {
            try {
                Desktop.getDesktop().mail(this.linklocation);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
    }
}

