/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;
import se.prediktera.map.common.cleanup.CleanUpToolBar;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.main.Main_GUI;

public class SmartToolBar
extends CleanUpToolBar {
    JPanel popupPanel = new JPanel();
    SmartButton popupButton = new SmartButton();
    ArrayList<Component> popupList = new ArrayList();
    JWindow popupMenu = new JWindow();

    public static void main(String[] stringArray) {
        JComponent jComponent;
        SmartToolBar smartToolBar = new SmartToolBar();
        for (int i = 0; i < 10; ++i) {
            jComponent = new JFlatButton();
            ((JFlatButton)jComponent).setIcon(new ImageIcon(Main_GUI.class.getResource("gif/zoom.png")));
            smartToolBar.add(jComponent);
        }
        JFrame jFrame = new JFrame();
        jComponent = (JPanel)jFrame.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)smartToolBar, "North");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public SmartToolBar() {
        this.init();
    }

    public SmartToolBar(String string) {
        super(string);
        this.init();
    }

    @Override
    public void doLayout() {
        int n;
        Component[] componentArray;
        if (this.popupList.isEmpty()) {
            componentArray = new Component[this.getComponentCount()];
            System.arraycopy(this.getComponents(), 0, componentArray, 0, this.getComponentCount());
        } else {
            componentArray = new Component[this.getComponentCount() + this.popupList.size() - 1];
            System.arraycopy(this.getComponents(), 0, componentArray, 0, this.getComponentCount() - 1);
            int n2 = 0;
            n = this.getComponentCount() - 1;
            while (n2 < this.popupList.size()) {
                componentArray[n] = this.popupList.get(n2);
                ++n2;
                ++n;
            }
        }
        this.removeAll();
        this.popupList.clear();
        Insets insets = this.getInsets();
        n = this.getWidth() - insets.left - insets.right;
        for (int i = 0; i < componentArray.length; ++i) {
            if (i == componentArray.length - 1 || (n -= componentArray[i].getWidth()) - componentArray[i + 1].getWidth() > 0) {
                this.add(componentArray[i]);
                continue;
            }
            if (n - this.popupButton.getWidth() > 0) {
                this.add(componentArray[i++]);
            }
            this.add(this.popupPanel);
            while (i < componentArray.length) {
                this.popupList.add(componentArray[i]);
                ++i;
            }
        }
        this.invalidate();
        super.doLayout();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.setSize(0.0, dimension.getHeight());
        return dimension;
    }

    @Override
    protected void cleanUpChild() {
    }

    private void init() {
        this.setMinimumSize(new Dimension(40, 30));
        this.popupButton.addActionListener(actionEvent -> {
            this.popupMenu.getContentPane().removeAll();
            for (Component component : this.popupList) {
                this.popupMenu.getContentPane().add(component);
            }
            this.popupMenu.setLocationRelativeTo(this.popupButton);
            this.popupMenu.setVisible(!this.popupMenu.isVisible());
            this.popupMenu.pack();
        });
        this.popupPanel.setLayout(new BorderLayout());
        this.popupPanel.add((Component)this.popupButton, "East");
    }

    class SmartButton
    extends JFlatButton {
        public SmartButton() {
            this.setMaximumSize(new Dimension(9, 27));
            this.setMinimumSize(new Dimension(9, 27));
            this.setPreferredSize(new Dimension(9, 27));
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.isEnabled()) {
                graphics2D.setColor(Color.darkGray);
                if (this.buttonDown) {
                    graphics2D.translate(0, 1);
                } else if (this.mouseOver) {
                    graphics2D.translate(0, -1);
                }
            } else {
                graphics2D.setColor(Color.black);
            }
            graphics2D.drawLine(2, 9, 4, 13);
            graphics2D.drawLine(4, 13, 6, 9);
            graphics2D.drawLine(2, 15, 4, 19);
            graphics2D.drawLine(4, 19, 6, 15);
        }
    }
}

