/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.JViewport;

public class ViewportWithBackground
extends JViewport {
    Image bg = null;
    GradientPaint gradient;

    public ViewportWithBackground(Dimension dimension) {
        this.setOpaque(false);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
    }

    public ViewportWithBackground(GradientPaint gradientPaint, Dimension dimension) {
        this(dimension);
        this.gradient = gradientPaint;
    }

    public ViewportWithBackground(Image image) {
        this(new Dimension(image.getWidth(null), image.getHeight(null)));
        this.setBackground(image);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            super.paintComponent(graphics);
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.bg != null) {
            graphics2D.setClip(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1);
            graphics2D.setColor(new Color(200, 200, 200, 200));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            Dimension dimension = this.getSize();
            int n = this.bg.getHeight(null);
            int n2 = this.bg.getWidth(null);
            for (int i = 0; i < dimension.height; i += n) {
                for (int j = 0; j < dimension.width; j += n2) {
                    graphics2D.drawImage(this.bg, j, i, null);
                }
            }
        } else if (this.gradient != null) {
            graphics2D.setPaint(this.gradient);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        graphics2D.dispose();
    }

    public void setBackground(Image image) {
        this.bg = image;
        this.setOpaque(image == null);
    }
}

