/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.filechooser;

import com.googlecode.jfilechooserbookmarks.AbstractBookmarksPanel;
import com.googlecode.jfilechooserbookmarks.example.CustomHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.opensave.PreviewInterface;
import se.prediktera.map.common.swing.SwingUtils;
import se.prediktera.map.common.swing.filechooser.ExtensionFilter;
import se.prediktera.map.common.swing.flat.TextIcon;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;

public class jopensaveDialog
extends JFileChooser {
    private final Component parent;
    private PreviewInterface previewInterface;
    private final Vector<ExtensionFilter> filterVector = new Vector();

    public static boolean equalExtension(String string, String string2) {
        if (string2.length() == 0) {
            // empty if block
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '*') {
                return true;
            }
            if (string.length() > i && string.charAt(i) == string2.charAt(i)) continue;
            return false;
        }
        return string.length() == string2.length();
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1).toLowerCase();
    }

    public static String getFileName(File file) {
        if (file != null) {
            String string = file.getName();
            int n = string.lastIndexOf(".");
            if (n == -1) {
                return string;
            }
            return string.substring(0, n);
        }
        return "noname";
    }

    public jopensaveDialog() {
        this("", (Component)null);
    }

    public jopensaveDialog(String string, Component component) {
        this(string, component, null);
    }

    public jopensaveDialog(String string, Component component, PreviewInterface previewInterface) {
        this.setDialogTitle(string);
        this.parent = component;
        this.setPreview(previewInterface, false);
        this.setAcceptAllFileFilterUsed(false);
        Action action = this.getActionMap().get("viewTypeDetails");
        if (action != null) {
            action.actionPerformed(null);
        }
        SwingUtilities.invokeLater(() -> this.attachEnterListenerToPathField(this));
    }

    public void addAllFiles() {
        this.addExtension(new String[]{"*"}, "All Files (*.*)", (byte)0, null);
    }

    public void addAllSupported() {
        int n = 0;
        for (int i = 0; i < this.filterVector.size(); ++i) {
            n += this.filterVector.elementAt((int)i).ext.length;
        }
        if (n > 0) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.filterVector.size(); ++i) {
                ExtensionFilter extensionFilter = this.filterVector.elementAt(i);
                for (String string : extensionFilter.ext) {
                    if (string.startsWith("*")) continue;
                    vector.addElement(string);
                }
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            this.filterVector.add(0, new ExtensionFilter(stringArray, "All Supported Files", 0, null));
        }
    }

    public FileFilter addExtension(AbstractImportInfo abstractImportInfo) {
        return this.addExtension(abstractImportInfo.getExt(), abstractImportInfo.getDescription(), (byte)0, abstractImportInfo);
    }

    public FileFilter addExtension(String[] stringArray, String string) {
        return this.addExtension(stringArray, string, (byte)0, null);
    }

    public FileFilter addExtension(String string, String string2) {
        return this.addExtension(new String[]{string}, string2, (byte)0, null);
    }

    public FileFilter addExtension(String[] stringArray, String string, byte by) {
        return this.addExtension(stringArray, string, by, null);
    }

    public FileFilter addExtension(String string, String string2, byte by) {
        return this.addExtension(new String[]{string}, string2, by, null);
    }

    public FileFilter addExtension(String[] stringArray, String string, byte by, Object object) {
        ExtensionFilter extensionFilter = new ExtensionFilter(stringArray, string, by, object);
        this.filterVector.add(extensionFilter);
        return extensionFilter;
    }

    public FileFilter addExtension(String[] stringArray, String string, Object object) {
        return this.addExtension(stringArray, string, (byte)0, object);
    }

    public FileFilter addExtension(String string, String string2, Object object) {
        return this.addExtension(new String[]{string}, string2, (byte)0, object);
    }

    public void addFiltersIntoDialog() {
        ExtensionFilter extensionFilter = null;
        for (int i = 0; i < this.filterVector.size(); ++i) {
            ExtensionFilter extensionFilter2 = this.filterVector.elementAt(i);
            this.addChoosableFileFilter(extensionFilter2);
            if (extensionFilter != null) continue;
            extensionFilter = extensionFilter2;
        }
        if (extensionFilter != null) {
            this.setFileFilter(extensionFilter);
        }
        this.filterVector.removeAllElements();
    }

    public ExtensionFilter getMatchingFilter() {
        FileFilter[] fileFilterArray;
        File file = this.getSelectedFile();
        for (FileFilter fileFilter : fileFilterArray = this.getChoosableFileFilters()) {
            if (!(fileFilter instanceof ExtensionFilter)) continue;
            ExtensionFilter extensionFilter = (ExtensionFilter)fileFilter;
            if (extensionFilter.object == null || !extensionFilter.accept(file)) continue;
            return extensionFilter;
        }
        return null;
    }

    public boolean isFileType(File file, byte by) {
        FileFilter[] fileFilterArray;
        for (FileFilter fileFilter : fileFilterArray = this.getChoosableFileFilters()) {
            ExtensionFilter extensionFilter;
            if (!(fileFilter instanceof ExtensionFilter) || !(extensionFilter = (ExtensionFilter)fileFilter).accept(file) || extensionFilter.getExtType() != by) continue;
            return true;
        }
        return false;
    }

    public boolean openshow() {
        this.addFiltersIntoDialog();
        if (this.showOpenDialog(this.parent) == 0) {
            File file = this.getSelectedFile();
            if (file == null || !file.exists()) {
                JOptionPane.showConfirmDialog(this, "File " + (file == null ? "" : file.getName()) + " doesn't exist", "File doesn't exist", -1, 0, null);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean saveshow() {
        this.addFiltersIntoDialog();
        if (this.showSaveDialog(this.parent) == 0) {
            ExtensionFilter extensionFilter;
            FileFilter fileFilter = this.getFileFilter();
            File file = this.getSelectedFile();
            file = ImportHelper.createLegalFile(file);
            if (fileFilter instanceof ExtensionFilter && !(extensionFilter = (ExtensionFilter)fileFilter).hasExtension(file)) {
                file = new File(String.valueOf(file) + "." + extensionFilter.getExtension(0));
                this.setSelectedFile(file);
            }
            if (file.isFile() && file.exists()) {
                int n = JOptionPane.showConfirmDialog(this, "File \"" + file.getName() + "\" already exists, overwrite?", "File exists", 0, 3, null);
                if (n == 0) {
                    if (!file.canWrite()) {
                        JOptionPane.showConfirmDialog(this, "File " + file.getName() + " is read-only. Please check the file properties and try again.", "Read-only", -1, 1, null);
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public File getLegalFileWithExtension(File file) {
        ExtensionFilter extensionFilter = (ExtensionFilter)this.getFileFilter();
        File file2 = ImportHelper.createLegalFile(file);
        if (extensionFilter != null && !extensionFilter.hasExtension(file2)) {
            return new File(String.valueOf(file2) + "." + extensionFilter.getExtension(0));
        }
        return file2;
    }

    public void setFileName(String string) {
        this.setSelectedFile(new File(string));
    }

    public void setPreview(PreviewInterface previewInterface, boolean bl) {
        this.previewInterface = previewInterface;
        if (this.previewInterface instanceof JComponent) {
            if (bl) {
                JTabbedPane jTabbedPane = new JTabbedPane();
                CustomFileChooserBookmarksPanel customFileChooserBookmarksPanel = new CustomFileChooserBookmarksPanel();
                customFileChooserBookmarksPanel.setOwner(this);
                jTabbedPane.addTab("Preview", (JComponent)((Object)this.previewInterface));
                jTabbedPane.addTab("Favorite folders", (Component)((Object)customFileChooserBookmarksPanel));
                this.setAccessory(jTabbedPane);
            } else {
                this.setAccessory((JComponent)((Object)this.previewInterface));
            }
            this.addPropertyChangeListener(propertyChangeEvent -> {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    File file = (File)propertyChangeEvent.getNewValue();
                    this.previewInterface.configure(file);
                }
            });
        } else if (bl) {
            CustomFileChooserBookmarksPanel customFileChooserBookmarksPanel = new CustomFileChooserBookmarksPanel();
            customFileChooserBookmarksPanel.setOwner(this);
            this.setAccessory((JComponent)((Object)customFileChooserBookmarksPanel));
        }
    }

    public JPopupMenu getPopupMenu() {
        JList jList;
        Container container = this.getContainer(this, "sun.swing.FilePane");
        if (container != null && (jList = SwingUtils.getDescendantOfType(JList.class, container, "Enabled", true)) != null) {
            return jList.getComponentPopupMenu();
        }
        return null;
    }

    private Container getContainer(Container container, String string) {
        if (container.getClass().getName().equals(string)) {
            return container;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Container container2;
            Component component = container.getComponent(i);
            if (!(component instanceof Container) || (container2 = this.getContainer((Container)component, string)) == null) continue;
            return container2;
        }
        return null;
    }

    public void checkComponentSize(Container container) {
        if (container instanceof JPanel) {
            Component[] componentArray = (Component[])container;
            if (componentArray.getMinimumSize().height > 500) {
                componentArray.setMinimumSize(new Dimension(0, 0));
            }
        }
        for (Component component : container.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.checkComponentSize((JComponent)component);
        }
    }

    @Override
    public Icon getIcon(File file) {
        try {
            Icon icon = super.getIcon(file);
            if (icon != null) {
                return icon;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new TextIcon("N/A");
    }

    @Override
    public void setCurrentDirectory(File file) {
        try {
            super.setCurrentDirectory(file);
            this.fixNameColumnWidth();
        }
        catch (Exception exception) {
            Logg.error("Cannot set directory", exception);
        }
    }

    private void fixNameColumnWidth() {
        JTable jTable = jopensaveDialog.findChildComponent(this, JTable.class);
        if (jTable != null) {
            JViewport jViewport = (JViewport)jTable.getParent();
            int n = jTable.getPreferredSize().width;
            int n2 = jViewport.getSize().width;
            if (n < n2) {
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n2 - n);
            }
        }
    }

    private static <T> T findChildComponent(Container container, Class<T> clazz) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            T t;
            Component component = container.getComponent(i);
            if (clazz.isInstance(component)) {
                return clazz.cast(component);
            }
            if (!(component instanceof Container) || (t = jopensaveDialog.findChildComponent((Container)component, clazz)) == null) continue;
            return t;
        }
        return null;
    }

    private void attachEnterListenerToPathField(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                jTextField.addActionListener(actionEvent -> {
                    File file = new File(jTextField.getText().trim());
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            this.setCurrentDirectory(file);
                        } else {
                            this.setSelectedFile(file);
                            this.rescanCurrentDirectory();
                        }
                    }
                });
                continue;
            }
            if (!(component instanceof Container)) continue;
            Container container2 = (Container)component;
            this.attachEnterListenerToPathField(container2);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Evince.setLookAndFeel();
        new jopensaveDialog().openshow();
    }

    public static class CustomFileChooserBookmarksPanel
    extends AbstractBookmarksPanel {
        protected CustomHandler.CustomFactory newFactory() {
            return new CustomHandler.CustomFactory(){

                public CustomHandler.CustomPropertiesHandler newPropertiesHandler() {
                    return new CustomHandler.CustomPropertiesHandler(){

                        protected String getFilename() {
                            return IniManager.getEvinceSettingsFile("favorite_folders.properties").getAbsolutePath();
                        }
                    };
                }
            };
        }
    }
}

