/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.flat;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.swing.flat.JFlatHelper;
import se.prediktera.map.main.Evince;

public class JFlatButton
extends JButton
implements MouseListener {
    protected boolean buttonDown = false;
    protected boolean mouseOver = false;
    private Icon icon;
    private boolean paintText = false;
    private CMenuItem menuItem;
    private Object object;

    public JFlatButton() {
        this(30, 27, false);
        this.setOpaque(false);
    }

    public JFlatButton(Icon icon) {
        this(30, 27, false, icon);
        this.setOpaque(false);
    }

    public JFlatButton(int n, int n2, boolean bl) {
        this(n, n2, bl, null);
    }

    public JFlatButton(int n, int n2, boolean bl, Icon icon) {
        this.paintText = bl;
        this.setIcon(icon);
        if (Evince.touchscreen) {
            n *= 2;
            n2 *= 2;
        }
        this.setRequestFocusEnabled(false);
        this.setMaximumSize(new Dimension(n, n2));
        this.setMinimumSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
        this.setMargin(new Insets(0, 0, 0, 0));
        this.addMouseListener(this);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        super.addActionListener(actionListener);
    }

    public JFlatButton copyButton() {
        JFlatButton jFlatButton = new JFlatButton();
        if (this.getActionListeners().length > 0) {
            jFlatButton.addActionListener(this.getActionListeners()[0]);
        }
        jFlatButton.setToolTipText(this.getToolTipText());
        jFlatButton.setIcon(this.getIcon());
        return jFlatButton;
    }

    public CMenuItem createMenuItem() {
        return this.createMenuItem(this.getToolTipText());
    }

    public CMenuItem createMenuItem(String string) {
        this.menuItem = new CMenuItem(this);
        if (string != null) {
            this.menuItem.setText(string);
        }
        this.menuItem.setEnabled(this.isEnabled());
        return this.menuItem;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.buttonDown = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.buttonDown = false;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getHeight() - 1;
        int n2 = this.getWidth() - 1;
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, n2 + 1, n + 1);
        }
        int n3 = 0;
        if (this.mouseOver && this.isEnabled()) {
            if (this.buttonDown) {
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawLine(0, 0, n2, 0);
                graphics2D.drawLine(1, 1, n2 - 2, 1);
                graphics2D.drawLine(0, 0, 0, n);
                graphics2D.drawLine(1, 1, 1, n - 2);
                graphics2D.setColor(Color.white);
                graphics2D.drawLine(0, n, n2, n);
                graphics2D.drawLine(n2, 0, n2, n);
                n3 = 1;
            } else {
                graphics2D.setColor(Color.white);
                graphics2D.drawLine(0, 0, n2, 0);
                graphics2D.drawLine(0, 0, 0, n);
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawLine(0, n, n2, n);
                graphics2D.drawLine(n2, 0, n2, n);
            }
        }
        if (this.icon != null) {
            this.drawIcon(graphics2D, this.icon, this.getWidth(), this.getHeight(), n3);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.menuItem != null) {
            this.menuItem.setEnabled(bl);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = JFlatHelper.setScaledIcon(icon);
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setPaintText(boolean bl) {
        this.paintText = bl;
    }

    protected void drawIcon(Graphics2D graphics2D, Icon icon, int n, int n2, int n3) {
        int n4 = (n - 1) / 2 - icon.getIconWidth() / 2 + n3;
        int n5 = (n2 - 1) / 2 - icon.getIconHeight() / 2 + n3;
        if (this.isEnabled()) {
            icon.paintIcon(this, graphics2D, n4, n5);
        } else {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            icon.paintIcon(this, graphics2D, n4, n5);
        }
        if (this.paintText) {
            String string = this.getText();
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getFont());
            int n6 = fontMetrics.stringWidth(string);
            int n7 = fontMetrics.getHeight();
            graphics2D.setColor(this.getForeground());
            graphics2D.setFont(this.getFont());
            graphics2D.drawString(string, this.getWidth() / 2 - n6 / 2 + n3, n7 + n3);
        }
    }
}

