/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.flat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.Main_GUI;

public class JFlatButtonComboBox
extends JPanel {
    protected AbstractButton selectedButton = null;
    protected final JPopupMenu popupMenu = new JPopupMenu();
    protected JFlatButton tripathButton = new JFlatButton();
    protected Icon icon;
    private final ButtonListener buttonListener = new ButtonListener();

    public JFlatButtonComboBox() {
        super(new BorderLayout());
        this.setOpaque(false);
        int n = 40;
        int n2 = 27;
        int n3 = 10;
        if (Evince.touchscreen) {
            n *= 2;
            n2 *= 2;
            n3 *= 2;
        }
        this.setMaximumSize(new Dimension(n, n2));
        this.setMinimumSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
        this.tripathButton.setMaximumSize(new Dimension(n3, n2));
        this.tripathButton.setMinimumSize(new Dimension(n3, n2));
        this.tripathButton.setPreferredSize(new Dimension(n3, n2));
        this.add((Component)this.tripathButton, "East");
        this.tripathButton.setIcon(new ImageIcon(Main_GUI.class.getResource("image/smallarrowdown.gif")));
        this.tripathButton.addActionListener(actionEvent -> this.popupMenu.show(this, 0, this.getHeight()));
    }

    public void addButton(AbstractButton abstractButton) {
        if (this.selectedButton == null) {
            this.setSelectedButton(abstractButton);
        }
        CMenuItem cMenuItem = new CMenuItem(abstractButton, false);
        cMenuItem.addActionListener(this.buttonListener);
        this.popupMenu.add(cMenuItem);
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
    }

    public CMenu createMenuItem(String string) {
        CMenu cMenu = string == null ? new CMenu(this.tripathButton.getToolTipText(), true) : new CMenu(string, true);
        for (int i = 0; i < this.popupMenu.getComponentCount(); ++i) {
            Component component = this.popupMenu.getComponent(i);
            if (component instanceof CMenuItem) {
                CMenuItem cMenuItem = (CMenuItem)component;
                component = (JFlatButton)cMenuItem.getButton();
                cMenu.add(((JFlatButton)component).createMenuItem(((JComponent)component).getToolTipText()));
                continue;
            }
            if (!(this.popupMenu.getComponent(i) instanceof JSeparator)) continue;
            cMenu.addSeparator();
        }
        cMenu.setEnabled(this.isEnabled());
        if (this.icon != null) {
            cMenu.setIcon(this.icon);
        }
        return cMenu;
    }

    public AbstractButton getButtonAt(int n) {
        int n2 = 0;
        for (int i = 0; i < this.popupMenu.getComponentCount(); ++i) {
            if (!(this.popupMenu.getComponent(i) instanceof AbstractButton) || n2++ != n) continue;
            return (AbstractButton)this.popupMenu.getComponent(i);
        }
        return null;
    }

    public int getButtonCount() {
        int n = 0;
        for (int i = 0; i < this.popupMenu.getComponentCount(); ++i) {
            if (!(this.popupMenu.getComponent(i) instanceof AbstractButton)) continue;
            ++n;
        }
        return n;
    }

    public void insertButton(AbstractButton abstractButton, int n) {
        if (this.selectedButton == null) {
            this.setSelectedButton(abstractButton);
        }
        CMenuItem cMenuItem = new CMenuItem(abstractButton, false);
        cMenuItem.addActionListener(this.buttonListener);
        this.popupMenu.insert(cMenuItem, n);
    }

    @Override
    public void removeAll() {
        this.popupMenu.removeAll();
        this.selectedButton = null;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.selectedButton != null) {
            this.selectedButton.setEnabled(bl);
        }
        this.tripathButton.setEnabled(bl);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setSelectedButton(AbstractButton abstractButton) {
        if (this.selectedButton != null) {
            this.remove(this.selectedButton);
        }
        this.selectedButton = abstractButton;
        this.add((Component)this.selectedButton, "Center");
        this.repaint();
        this.updateUI();
    }

    public void setSelectedButtonAndClick(AbstractButton abstractButton) {
        if (abstractButton != this.selectedButton) {
            this.setSelectedButton(abstractButton);
        }
        if (this.selectedButton != null && !this.selectedButton.isSelected()) {
            this.selectedButton.doClick();
        }
    }

    @Override
    public void setToolTipText(String string) {
        this.tripathButton.setToolTipText(string);
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CMenuItem cMenuItem = (CMenuItem)actionEvent.getSource();
            JFlatButtonComboBox.this.setSelectedButtonAndClick(cMenuItem.getButton());
        }
    }
}

