/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.flat;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import se.prediktera.map.common.CMenuItem;
import se.prediktera.map.common.swing.flat.JFlatButton;

public class JFlatComboBox
extends JFlatButton {
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final Vector<ItemListener> itemListeners = new Vector();
    private int itemindex = 0;
    private int selindex = 0;
    private final GeneralPath tripath = new GeneralPath();

    public JFlatComboBox() {
        this.setMaximumSize(new Dimension(40, 27));
        this.setMinimumSize(new Dimension(40, 27));
        this.setPreferredSize(new Dimension(40, 27));
        this.addActionListener(actionEvent -> this.popupMenu.show(this, 0, this.getHeight()));
        this.tripath.moveTo(-2.0f, -1.0f);
        this.tripath.lineTo(2.0f, -1.0f);
        this.tripath.lineTo(0.0f, 1.0f);
        this.tripath.closePath();
    }

    public void addItem(String string, Icon icon) {
        CMenuItem cMenuItem = new CMenuItem(new ComboItem(string, icon, this.itemindex++));
        cMenuItem.setIcon(icon);
        cMenuItem.addActionListener(actionEvent -> this.itemSelected((CMenuItem)actionEvent.getSource()));
        this.popupMenu.add(cMenuItem);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.add(itemListener);
    }

    public CMenuItem getItemAt(int n) {
        return (CMenuItem)this.popupMenu.getComponent(n);
    }

    public int getItemCount() {
        return this.popupMenu.getComponentCount();
    }

    public int getSelectedIndex() {
        return this.selindex;
    }

    public void setSelectedIndex(int n) {
        this.selindex = n;
        this.itemSelected(this.getItemAt(n));
        this.repaint();
    }

    @Override
    protected void drawIcon(Graphics2D graphics2D, Icon icon, int n, int n2, int n3) {
        int n4 = 5 + n3;
        int n5 = (n2 - 1) / 2 - icon.getIconHeight() / 2 + n3;
        if (this.isEnabled()) {
            icon.paintIcon(this, graphics2D, n4, n5);
        } else {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            icon.paintIcon(this, graphics2D, n4, n5);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(n - 7 + n3, n2 / 2 + n3);
        graphics2D.setColor(Color.black);
        graphics2D.fill(this.tripath);
        graphics2D.draw(this.tripath);
        graphics2D.setTransform(affineTransform);
    }

    private void itemSelected(CMenuItem cMenuItem) {
        ComboItem comboItem = (ComboItem)cMenuItem.getObject();
        this.setIcon(comboItem.getIcon());
        this.setToolTipText(comboItem.toString());
        this.selindex = comboItem.getIndex();
        for (int i = 0; i < this.itemListeners.size(); ++i) {
            ItemListener itemListener = this.itemListeners.elementAt(i);
            itemListener.itemStateChanged(new ItemEvent(this, 0, null, 1));
        }
    }

    private static class ComboItem {
        private final String text;
        private final int index;
        private final Icon icon;

        public ComboItem(String string, Icon icon, int n) {
            this.text = string;
            this.index = n;
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.text;
        }
    }
}

