/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.flat;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.CRadioButtonMenuItem;
import se.prediktera.map.common.swing.flat.JFlatHelper;
import se.prediktera.map.main.Evince;

public class JFlatToggleButton
extends JToggleButton
implements MouseListener {
    private boolean buttonDown = false;
    private boolean mouseOver = false;
    private Icon icon;
    private Icon menuIcon = null;
    private boolean paintText = false;
    private CRadioButtonMenuItem menuItem;
    private Object holdObject;

    public JFlatToggleButton() {
        this(30, 27, false);
    }

    public JFlatToggleButton(int n, int n2, boolean bl) {
        this.paintText = bl;
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        if (Evince.touchscreen) {
            n *= 2;
            n2 *= 2;
        }
        this.setMaximumSize(new Dimension(n, n2));
        this.setMinimumSize(new Dimension(n, n2));
        this.setPreferredSize(new Dimension(n, n2));
        this.setMargin(new Insets(0, 0, 0, 0));
        this.addMouseListener(this);
        this.addItemListener(new ToggleMenuAction());
    }

    public CRadioButtonMenuItem createMenuItem(String string) {
        this.menuItem = new CRadioButtonMenuItem(this);
        if (string != null) {
            this.menuItem.setText(string);
        }
        this.menuItem.setEnabled(this.isEnabled());
        return this.menuItem;
    }

    public CMenu createSubMenu(String string, String string2, String string3) {
        CMenu cMenu = new CMenu(string, false);
        cMenu.setIcon(this.getIcon());
        CRadioButtonMenuItem cRadioButtonMenuItem = new CRadioButtonMenuItem(this);
        if (string2 != null) {
            cRadioButtonMenuItem.setText(string2);
        }
        cRadioButtonMenuItem.setIcon(null);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string3);
        jRadioButtonMenuItem.setSelected(!this.isSelected());
        ActionListener[] actionListenerArray = this.getActionListeners();
        for (ActionListener actionListener : actionListenerArray) {
            jRadioButtonMenuItem.addActionListener(actionListener);
        }
        jRadioButtonMenuItem.addItemListener(itemEvent -> this.setSelected(!this.isSelected()));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(cRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        cMenu.add(cRadioButtonMenuItem);
        cMenu.add(jRadioButtonMenuItem);
        return cMenu;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public Icon getMenuIcon() {
        if (this.menuIcon == null) {
            return this.icon;
        }
        return this.menuIcon;
    }

    public Object getObject() {
        return this.holdObject;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.buttonDown = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.buttonDown = false;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getHeight() - 1;
        int n2 = this.getWidth() - 1;
        int n3 = 0;
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, n2 + 1, n + 1);
        }
        boolean bl = this.isEnabled();
        if (this.mouseOver && bl || this.isSelected()) {
            if (this.buttonDown && bl || this.isSelected()) {
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, n2 + 1, n + 1);
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawLine(0, 0, n2, 0);
                graphics2D.drawLine(1, 1, n2 - 2, 1);
                graphics2D.drawLine(0, 0, 0, n);
                graphics2D.drawLine(1, 1, 1, n - 2);
                graphics2D.setColor(Color.white);
                graphics2D.drawLine(0, n, n2, n);
                graphics2D.drawLine(n2, 0, n2, n);
                n3 = 1;
            } else {
                graphics2D.setColor(Color.white);
                graphics2D.drawLine(0, 0, n2, 0);
                graphics2D.drawLine(0, 0, 0, n);
                graphics2D.setColor(Color.lightGray);
                graphics2D.drawLine(0, n, n2, n);
                graphics2D.drawLine(n2, 0, n2, n);
            }
        }
        this.paintIcon(graphics2D, n3);
        if (this.paintText) {
            String string = this.getText();
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            int n4 = fontMetrics.stringWidth(string);
            int n5 = fontMetrics.getHeight();
            graphics2D.setColor(this.getForeground());
            graphics2D.setFont(this.getFont());
            graphics2D.drawString(string, this.getWidth() / 2 - n4 / 2 + n3, n5 + n3);
        }
    }

    public void paintIcon(Graphics2D graphics2D, int n) {
        if (this.icon != null) {
            int n2 = (this.getWidth() - 1) / 2 - this.icon.getIconWidth() / 2 + n;
            int n3 = (this.getHeight() - 1) / 2 - this.icon.getIconHeight() / 2 + n;
            if (!this.isEnabled()) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            this.icon.paintIcon(this, graphics2D, n2, n3);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.menuItem != null) {
            this.menuItem.setEnabled(bl);
        }
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = JFlatHelper.setScaledIcon(icon);
    }

    public void setMenuIcon(Icon icon) {
        this.menuIcon = icon;
    }

    public void setObject(Object object) {
        this.holdObject = object;
    }

    public void setPaintText(boolean bl) {
        this.paintText = bl;
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.menuItem != null) {
            this.menuItem.setSelected(bl);
        }
    }

    public class ToggleMenuAction
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (JFlatToggleButton.this.menuItem != null && JFlatToggleButton.this.menuItem.isSelected() != JFlatToggleButton.this.isSelected()) {
                if (itemEvent.getSource() instanceof JFlatToggleButton) {
                    JFlatToggleButton.this.menuItem.setSelected(JFlatToggleButton.this.isSelected());
                } else {
                    JFlatToggleButton.this.setSelected(JFlatToggleButton.this.menuItem.isSelected());
                }
            }
        }
    }
}

