/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.DefaultDesktopManager;
import javax.swing.JInternalFrame;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.scrollabledesktop.BaseDesktopPane;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;

public class BaseDesktopManager
extends DefaultDesktopManager {
    private final BaseDesktopPane desktopPane;

    public BaseDesktopManager(BaseDesktopPane baseDesktopPane) {
        this.desktopPane = baseDesktopPane;
    }

    @Override
    public void activateFrame(JInternalFrame jInternalFrame) {
        JInternalFrame[] jInternalFrameArray;
        super.activateFrame(jInternalFrame);
        for (JInternalFrame jInternalFrame2 : jInternalFrameArray = this.desktopPane.getAllFrames()) {
            try {
                if (jInternalFrame2 == jInternalFrame || !jInternalFrame2.isSelected()) continue;
                jInternalFrame2.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (jInternalFrame instanceof BaseInternalFrame) {
            ((BaseInternalFrame)jInternalFrame).selectFrameAndAssociatedButtons();
        }
    }

    @Override
    public void closeFrame(JInternalFrame jInternalFrame) {
        super.closeFrame(jInternalFrame);
        if (jInternalFrame instanceof BaseInternalFrame) {
            this.desktopPane.removeAssociatedComponents((BaseInternalFrame)jInternalFrame);
        }
        this.desktopPane.resizeDesktop();
    }

    @Override
    public void maximizeFrame(JInternalFrame jInternalFrame) {
        super.maximizeFrame(jInternalFrame);
        Rectangle rectangle = this.desktopPane.getScrollPaneRectangle();
        jInternalFrame.setNormalBounds(jInternalFrame.getBounds());
        this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            Logg.error(propertyVetoException.getMessage(), new Object[0]);
        }
        this.removeIconFor(jInternalFrame);
    }

    @Override
    public void minimizeFrame(JInternalFrame jInternalFrame) {
        super.minimizeFrame(jInternalFrame);
        if (jInternalFrame instanceof BaseInternalFrame) {
            BaseInternalFrame baseInternalFrame = (BaseInternalFrame)jInternalFrame;
            Rectangle rectangle = baseInternalFrame.getInitialRectangle();
            this.setBoundsForFrame(jInternalFrame, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

