/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.scrollabledesktop.BaseDesktopManager;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.BaseToggleButton;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopListener;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopMediator;
import se.prediktera.map.common.swing.scrollabledesktop.FramePositioning;
import se.prediktera.map.main.AbstractGUI;

public class BaseDesktopPane
extends JDesktopPane {
    private static final Color BG_TEXT_COLOR = new Color(118, 118, 118);
    private static final Font BG_TEXT_FONT = new Font("Times", 1, 20);
    private final DesktopMediator desktopMediator;
    private final FramePositioning positioning;
    private final String areaName;

    public BaseDesktopPane(String string, DesktopMediator desktopMediator) {
        this.desktopMediator = desktopMediator;
        this.positioning = new FramePositioning(this);
        this.areaName = string;
        this.setBackground(Color.GRAY);
        this.setDesktopManager(new BaseDesktopManager(this));
        this.setDragMode(1);
    }

    public void add(DesktopListener desktopListener, JInternalFrame jInternalFrame, int n, int n2) {
        jInternalFrame.addComponentListener(desktopListener);
        this.initAndAddFrame(jInternalFrame, n, n2, 0);
    }

    public BaseInternalFrame add(DesktopListener desktopListener, String string, ImageIcon imageIcon, AbstractGUI abstractGUI, boolean bl, int n, int n2, JPanel jPanel, int n3) {
        BaseInternalFrame baseInternalFrame = this.createInternalFrame(desktopListener, string, imageIcon, abstractGUI, bl, jPanel, n3);
        this.initAndAddFrame(baseInternalFrame, n, n2, n3);
        return baseInternalFrame;
    }

    public Point cascadeInternalFrame(JInternalFrame jInternalFrame) {
        return this.positioning.cascadeInternalFrame(jInternalFrame);
    }

    public void cascadeInternalFrames() {
        this.positioning.cascadeInternalFrames();
    }

    public void cleanUp() {
        if (this.positioning != null) {
            this.positioning.cleanUp();
        }
    }

    public void closeSelectedFrame() {
        JInternalFrame jInternalFrame = this.getSelectedFrame();
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public BaseInternalFrame createInternalFrame(DesktopListener desktopListener, String string, ImageIcon imageIcon, AbstractGUI abstractGUI, boolean bl, JPanel jPanel, int n) {
        BaseInternalFrame baseInternalFrame = new BaseInternalFrame(string, imageIcon, abstractGUI, bl, jPanel, n);
        baseInternalFrame.addComponentListener(desktopListener);
        return baseInternalFrame;
    }

    public void flagContentsChanged(JInternalFrame jInternalFrame) {
        if (this.getSelectedFrame() != jInternalFrame && jInternalFrame instanceof BaseInternalFrame) {
            BaseToggleButton baseToggleButton = (BaseToggleButton)((BaseInternalFrame)jInternalFrame).getAssociatedButton();
            baseToggleButton.flagContentsChanged(true);
        }
    }

    public byte getAutoMode() {
        return this.positioning.getAutoMode();
    }

    public boolean getAutoTile() {
        return this.positioning.getAutoMode() == 0 || this.positioning.getAutoMode() == 3;
    }

    public Dimension getDesktopSize() {
        return this.getPreferredSize();
    }

    public int getNumberOfFrames() {
        return this.getComponentCount();
    }

    public Rectangle getScrollPaneRectangle() {
        return this.getVisibleRect();
    }

    public boolean hasFrames() {
        return this.getAllFrames().length > 0;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public void maximumInternalFrame(JInternalFrame jInternalFrame, boolean bl) {
        this.positioning.maximumInternalFrame(jInternalFrame, bl);
    }

    public void maximumInternalFrames(boolean bl) {
        this.positioning.maximumInternalFrames(bl);
    }

    @Override
    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Color color = this.getBackground();
        if (color == null) {
            color = Color.lightGray;
        }
        graphics.setFont(BG_TEXT_FONT);
        int n = graphics.getFontMetrics().stringWidth(this.areaName);
        graphics.setColor(color);
        if (rectangle == null) {
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(BG_TEXT_COLOR);
        graphics.drawString(this.areaName, (this.getWidth() - n) / 2, this.getHeight() / 2);
        super.paint(graphics);
    }

    public void removeAssociatedComponents(BaseInternalFrame baseInternalFrame) {
        if (this.desktopMediator != null) {
            this.desktopMediator.removeAssociatedComponents(baseInternalFrame);
        }
    }

    public void resizeDesktop() {
        if (this.getAutoTile() && !this.positioning.isOneFrameMaximized()) {
            this.positioning.tileInternalFrames();
        }
    }

    public void selectNextFrame() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        if (jInternalFrameArray.length > 0) {
            try {
                jInternalFrameArray[0].setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                Logg.error("Bean veto", propertyVetoException.getMessage());
            }
        }
    }

    public void setAllFramesMaximum(boolean bl) {
        this.maximumInternalFrames(bl);
    }

    public void setAutoMode(byte by, boolean bl) {
        this.positioning.setAutoMode(by, bl);
    }

    public void setDesktopSize(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    @Override
    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        super.setSelectedFrame(jInternalFrame);
        if (jInternalFrame instanceof BaseInternalFrame) {
            BaseInternalFrame baseInternalFrame = (BaseInternalFrame)jInternalFrame;
            baseInternalFrame.selectFrameAndAssociatedButtons();
        }
    }

    public void tileInternalFrames() {
        this.positioning.tileInternalFrames();
    }

    private void initAndAddFrame(JInternalFrame jInternalFrame, int n, int n2, int n3) {
        if (n3 == 0 && this.positioning.getAutoMode() == 2) {
            ((BaseInternalFrame)jInternalFrame).preSetMaximum(true);
        }
        this.add((Component)jInternalFrame, (Object)n3);
        if (n != -1 && n2 != -1) {
            jInternalFrame.setLocation(n, n2);
        } else if (n3 == 0) {
            switch (this.positioning.getAutoMode()) {
                case 2: {
                    this.positioning.maximumInternalFrame(jInternalFrame, true);
                    break;
                }
                case 1: {
                    jInternalFrame.setLocation(this.cascadeInternalFrame(jInternalFrame));
                    break;
                }
            }
        }
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.resizeDesktop();
    }
}

