/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.scrollabledesktop.BaseFrameInterface;
import se.prediktera.map.common.swing.scrollabledesktop.BaseMaximizePanel;
import se.prediktera.map.common.swing.scrollabledesktop.BaseToggleButton;
import se.prediktera.map.common.swing.scrollabledesktop.FrameAccessorInterface;
import se.prediktera.map.common.swing.scrollabledesktop.JScrollableDesktopPane;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.AbstractMainGUI;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class BaseInternalFrame
extends JInternalFrame
implements VetoableChangeListener,
FrameAccessorInterface {
    private JToggleButton associatedButton;
    private BaseFrameInterface associatedFrameInterface;
    private JRadioButtonMenuItem associatedMenuButton;
    private BaseMaximizePanel baseMaxmimizePanel = null;
    private JPanel framePanel;
    private int initialX;
    private int initialY;
    private int initialWidth;
    private int initialHeight;
    private Border normalBorder;
    private AbstractGUI frameGUI = null;
    private int layer;
    private int tileIndex;
    private JComponent northPane;

    public BaseInternalFrame() {
        this.addVetoableChangeListener(this);
        this.saveSize();
    }

    public BaseInternalFrame(String string) {
        super(string);
        this.addVetoableChangeListener(this);
        this.saveSize();
    }

    public BaseInternalFrame(String string, boolean bl) {
        super(string, bl);
        this.addVetoableChangeListener(this);
        this.saveSize();
    }

    public BaseInternalFrame(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
        this.addVetoableChangeListener(this);
        this.saveSize();
    }

    public BaseInternalFrame(String string, boolean bl, boolean bl2, boolean bl3) {
        super(string, bl, bl2, bl3);
        this.addVetoableChangeListener(this);
        this.saveSize();
    }

    public BaseInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, bl, bl2, bl3, bl4);
        this.addVetoableChangeListener(this);
        this.saveSize();
    }

    public BaseInternalFrame(String string, ImageIcon imageIcon, AbstractGUI abstractGUI, boolean bl, JPanel jPanel, int n) {
        super(string, true, bl, true, true);
        this.layer = n;
        if (abstractGUI instanceof AbstractMainGUI) {
            this.setClosable(false);
        }
        this.frameGUI = abstractGUI;
        if (jPanel != null) {
            this.baseMaxmimizePanel = new BaseMaximizePanel(this);
        }
        if (this.frameGUI.getGUI_Name().length() > 0) {
            this.setTitle(this.frameGUI.getGUI_Name());
        }
        this.addVetoableChangeListener(this);
        this.framePanel = jPanel;
        this.normalBorder = this.getBorder();
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
        this.northPane = basicInternalFrameUI.getNorthPane();
        this.setBackground(Color.white);
        this.setForeground(Color.blue);
        if (imageIcon != null) {
            this.setFrameIcon(imageIcon);
        } else {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 3);
            this.setFrameIcon(new ImageIcon(bufferedImage));
        }
        this.getContentPane().add(abstractGUI);
        this.pack();
        this.saveSize();
        this.setVisible(true);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.initialWidth == 0 && this.initialHeight == 0) {
            this.saveSize();
        }
    }

    public void cleanUp() {
        this.frameGUI = null;
        this.associatedFrameInterface = null;
        if (this.framePanel != null) {
            this.framePanel.removeAll();
            this.framePanel = null;
        }
        this.removeAll();
    }

    public JToggleButton getAssociatedButton() {
        return this.associatedButton;
    }

    @Override
    public BaseInternalFrame getAssociatedFrame() {
        return this;
    }

    public JRadioButtonMenuItem getAssociatedMenuButton() {
        return this.associatedMenuButton;
    }

    public AbstractGUI getFrameGUI() {
        return this.frameGUI;
    }

    public Dimension getInitialDimensions() {
        return new Dimension(this.initialWidth, this.initialHeight);
    }

    public Rectangle getInitialRectangle() {
        return new Rectangle(this.initialX, this.initialY, this.initialWidth, this.initialHeight);
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    public int getTileIndex() {
        return this.tileIndex;
    }

    @Override
    public String getTitle() {
        if (this.frameGUI != null) {
            return this.frameGUI.getGUI_Name();
        }
        return super.getTitle();
    }

    @Override
    public boolean isClosable() {
        if (this.frameGUI != null) {
            return this.frameGUI.isClosable();
        }
        return true;
    }

    public void preSetMaximum(boolean bl) {
        if (this.framePanel != null && bl != this.isMaximum()) {
            BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
            if (bl) {
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
                basicInternalFrameUI.setNorthPane(null);
            } else {
                this.setBorder(this.normalBorder);
                this.setRootPaneCheckingEnabled(false);
                basicInternalFrameUI.setNorthPane(this.northPane);
                this.setRootPaneCheckingEnabled(true);
            }
        }
    }

    public void selectFrameAndAssociatedButtons() {
        if (this.frameGUI != null) {
            this.setAssociatedButtonsAndTitle();
            try {
                this.setSelected(true);
                this.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                Logg.error(propertyVetoException.getMessage(), new Object[0]);
            }
            this.frameGUI.selectedFrameUpdated(this);
            this.activateFrameBar();
            this.setVisible(true);
        }
    }

    public void setAssociatedButton(JToggleButton jToggleButton) {
        this.associatedButton = jToggleButton;
    }

    public void setAssociatedButtonsAndTitle() {
        if (this.associatedButton != null) {
            this.associatedButton.setSelected(true);
            ((BaseToggleButton)this.associatedButton).flagContentsChanged(false);
        }
        if (this.associatedFrameInterface != null && this.associatedFrameInterface.getSelectedItem() != this) {
            this.associatedFrameInterface.setSelectedItem(this);
        }
        if (this.associatedMenuButton != null) {
            this.associatedMenuButton.setSelected(true);
        }
    }

    @Override
    public void setAssociatedFrame(BaseInternalFrame baseInternalFrame) {
    }

    public void setAssociatedFrameInterface(BaseFrameInterface baseFrameInterface) {
        this.associatedFrameInterface = baseFrameInterface;
    }

    public void setAssociatedMenuButton(JRadioButtonMenuItem jRadioButtonMenuItem) {
        this.associatedMenuButton = jRadioButtonMenuItem;
    }

    public void setFramePanel(JPanel jPanel) {
        this.framePanel = jPanel;
    }

    @Override
    public void setIcon(boolean bl) throws PropertyVetoException {
        if (bl) {
            this.setMaximum(false);
        }
        super.setIcon(bl);
    }

    @Override
    public void setMaximum(boolean bl) throws PropertyVetoException {
        AbstractWindow_GUI abstractWindow_GUI;
        this.preSetMaximum(bl);
        super.setMaximum(bl);
        if (this.frameGUI instanceof AbstractWindow && (abstractWindow_GUI = ((AbstractWindow)this.frameGUI).getWindowGui()) != null) {
            JScrollableDesktopPane jScrollableDesktopPane = abstractWindow_GUI.getDesktop();
            if (bl) {
                this.frameGUI.windowChangeSizeEvent();
                jScrollableDesktopPane.setAutoMode((byte)2);
            } else if (jScrollableDesktopPane.getAutoMode() == 2) {
                jScrollableDesktopPane.setLastMode();
            }
        }
        this.activateFrameBar();
    }

    public void setTileIndex(int n) {
        this.tileIndex = n;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        this.frameGUI.selectedFrameUpdated(this);
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        boolean bl;
        if (propertyChangeEvent.getPropertyName().equals("closed") && (bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) && this.frameGUI != null) {
            this.frameGUI.closing();
            this.frameGUI = null;
        }
    }

    private void activateFrameBar() {
        if (this.baseMaxmimizePanel != null && this.framePanel != null) {
            this.framePanel.removeAll();
            if (this.isMaximum()) {
                this.framePanel.add((Component)this.baseMaxmimizePanel, "North");
            }
            this.framePanel.updateUI();
        }
    }

    private void saveSize() {
        this.initialX = this.getLocation().x;
        this.initialY = this.getLocation().y;
        this.initialWidth = this.getWidth();
        this.initialHeight = this.getHeight();
    }
}

