/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.flat.JFlatButton;
import se.prediktera.map.common.swing.scrollabledesktop.BaseFrameInterface;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.FrameAccessorInterface;
import se.prediktera.map.main.Main_GUI;

public class BaseTabbedPane
extends CleanUpPanel
implements FrameAccessorInterface,
BaseFrameInterface,
ItemSelectable {
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private final JFlatButton button = new JFlatButton();

    public BaseTabbedPane() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.button.setToolTipText("Show Window Properties");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.button.setIcon(new ImageIcon(Main_GUI.class.getResource("gif/buttondialog.gif")));
        this.button.setPreferredSize(new Dimension(16, 21));
        this.button.setRequestFocusEnabled(false);
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPane.setUI(new MyTabbedPaneUI());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.tabbedPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        this.add((Component)this.button, gridBagConstraints);
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.button.addActionListener(actionListener);
    }

    @Override
    public void addItem(Object object) {
        this.tabbedPane.addTab(object.toString(), new EmptyPanel(object));
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        ChangeListener changeListener = changeEvent -> {
            EmptyPanel emptyPanel = (EmptyPanel)this.tabbedPane.getSelectedComponent();
            if (emptyPanel != null) {
                itemListener.itemStateChanged(new ItemEvent(this, 0, emptyPanel.getFrame(), 701));
            }
        };
        this.tabbedPane.addChangeListener(changeListener);
    }

    @Override
    public void addPopupMenu(MouseAdapter mouseAdapter) {
        this.tabbedPane.addMouseListener(mouseAdapter);
    }

    @Override
    public BaseInternalFrame getAssociatedFrame() {
        EmptyPanel emptyPanel = (EmptyPanel)this.tabbedPane.getSelectedComponent();
        if (emptyPanel != null) {
            return emptyPanel.getFrame();
        }
        return null;
    }

    @Override
    public Color getCellBackground() {
        return this.tabbedPane.getBackground();
    }

    @Override
    public Object getSelectedItem() {
        EmptyPanel emptyPanel = (EmptyPanel)this.tabbedPane.getSelectedComponent();
        if (emptyPanel != null) {
            return emptyPanel.getFrame();
        }
        return null;
    }

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    @Override
    public void removeItem(Object object) {
        int n = this.getIndexFromFrame(object);
        if (n > -1) {
            this.tabbedPane.removeTabAt(n);
        }
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
    }

    @Override
    public void setAssociatedFrame(BaseInternalFrame baseInternalFrame) {
    }

    @Override
    public void setSelectedItem(Object object) {
        int n = this.getIndexFromFrame(object);
        if (n > -1) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    @Override
    protected void cleanUpChild() {
    }

    private int getIndexFromFrame(Object object) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            EmptyPanel emptyPanel = (EmptyPanel)this.tabbedPane.getComponentAt(i);
            if (emptyPanel == null || !emptyPanel.getFrame().equals(object)) continue;
            return i;
        }
        return -1;
    }

    public static class MyTabbedPaneUI
    extends BasicTabbedPaneUI {
        @Override
        protected Insets getContentBorderInsets(int n) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        protected void paintContentBorder(Graphics graphics, int n, int n2) {
        }
    }

    private class EmptyPanel
    extends JPanel {
        private final Object frame;

        public EmptyPanel(Object object) {
            this.frame = object;
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        public BaseInternalFrame getFrame() {
            return (BaseInternalFrame)this.frame;
        }
    }
}

