/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.swing.JComboBoxCell;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopMediator;
import se.prediktera.map.common.swing.scrollabledesktop.FrameAccessorInterface;

public class DesktopListener
extends CleanUpClass
implements ComponentListener,
ActionListener,
ItemListener,
InternalFrameListener {
    private DesktopMediator desktopMediator;
    private BaseInternalFrame associatedFrame = null;

    public DesktopListener(DesktopMediator desktopMediator) {
        this.desktopMediator = desktopMediator;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.desktopMediator == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("Tile")) {
            this.desktopMediator.tileInternalFrames();
        } else if (string.equals("Cascade")) {
            this.desktopMediator.cascadeInternalFrames();
        } else if (string.equals("Minimize All")) {
            this.desktopMediator.setAllFramesMaximum(false);
        } else if (string.equals("Maximize All")) {
            this.desktopMediator.setAllFramesMaximum(true);
        } else if (string.equals("Close")) {
            this.desktopMediator.closeSelectedFrame();
        } else if (string.equals("TilehorRadio")) {
            this.desktopMediator.setAutoMode((byte)0);
        } else if (string.equals("TileverRadio")) {
            this.desktopMediator.setAutoMode((byte)3);
        } else if (string.equals("CascadeRadio")) {
            this.desktopMediator.setAutoMode((byte)1);
        } else if (string.equals("MaximumRadio")) {
            this.desktopMediator.setAutoMode((byte)2);
        } else {
            this.frameChange(actionEvent);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this.desktopMediator != null) {
            this.desktopMediator.resizeDesktop();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.desktopMediator != null) {
            this.desktopMediator.resizeDesktop();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.desktopMediator != null) {
            this.desktopMediator.revalidateViewport();
        }
    }

    public void frameChange(AWTEvent aWTEvent) {
        BaseInternalFrame baseInternalFrame = null;
        if (aWTEvent.getSource() instanceof BaseInternalFrame) {
            baseInternalFrame = (BaseInternalFrame)aWTEvent.getSource();
        } else if (aWTEvent.getSource() instanceof FrameAccessorInterface) {
            baseInternalFrame = ((FrameAccessorInterface)aWTEvent.getSource()).getAssociatedFrame();
        } else {
            JComboBoxCell jComboBoxCell;
            Object object = aWTEvent.getSource();
            if (object instanceof JComboBoxCell && (object = (FrameAccessorInterface)(jComboBoxCell = (JComboBoxCell)object).getSelectedItem()) != null) {
                baseInternalFrame = object.getAssociatedFrame();
            }
        }
        if (baseInternalFrame != null && baseInternalFrame != this.associatedFrame) {
            this.associatedFrame = baseInternalFrame;
            this.associatedFrame.selectFrameAndAssociatedButtons();
        }
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.frameChange(internalFrameEvent);
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        this.frameChange(internalFrameEvent);
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        this.frameChange(internalFrameEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.frameChange(itemEvent);
    }

    @Override
    protected void cleanUpChild() {
        this.desktopMediator = null;
    }
}

