/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.swing.scrollabledesktop.BaseDesktopPane;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopConstants;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopListener;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopMenu;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopStatusBar;
import se.prediktera.map.common.swing.scrollabledesktop.JScrollableDesktopPane;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.IniManager;
import se.prediktera.map.main.window.AbstractWindow_GUI;
import se.prediktera.map.main.window.WindowToolbar;

public class DesktopMediator
extends CleanUpClass
implements DesktopConstants {
    private final BaseDesktopPane baseDesktopPane;
    private DesktopStatusBar desktopStatusBar;
    private final DesktopListener dListener;
    private DesktopMenu dMenu;
    private WindowToolbar windowToolbar;
    private final JScrollableDesktopPane mainPane;
    private byte lastMode = 0;

    public DesktopMediator(JScrollableDesktopPane jScrollableDesktopPane, AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super("DesktopMediator");
        this.mainPane = jScrollableDesktopPane;
        this.baseDesktopPane = new BaseDesktopPane(abstractWindow_GUI.getAreaName(), this);
        this.dListener = new DesktopListener(this);
        if (bl) {
            this.desktopStatusBar = new DesktopStatusBar("Toolbar", this);
            this.windowToolbar = new WindowToolbar(jScrollableDesktopPane, abstractWindow_GUI);
        }
        jScrollableDesktopPane.add((Component)this.baseDesktopPane, "Center");
        jScrollableDesktopPane.addComponentListener(this.dListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.dListener.actionPerformed(actionEvent);
    }

    public void add(JInternalFrame jInternalFrame, int n, int n2) {
        this.baseDesktopPane.add(this.dListener, jInternalFrame, n, n2);
        this.createFrameAssociates((BaseInternalFrame)jInternalFrame);
    }

    public JInternalFrame add(String string, ImageIcon imageIcon, AbstractGUI abstractGUI, boolean bl, int n, int n2, JPanel jPanel, int n3) {
        BaseInternalFrame baseInternalFrame = this.baseDesktopPane.add(this.dListener, string, imageIcon, abstractGUI, bl, n, n2, jPanel, n3);
        this.createFrameAssociates(baseInternalFrame);
        return baseInternalFrame;
    }

    public void autoTitle() {
        if (this.baseDesktopPane.getAutoTile()) {
            this.baseDesktopPane.tileInternalFrames();
        }
    }

    public void cascadeInternalFrames() {
        this.baseDesktopPane.cascadeInternalFrames();
    }

    public void closeSelectedFrame() {
        this.baseDesktopPane.closeSelectedFrame();
    }

    public JInternalFrame createInternalFrame(String string, ImageIcon imageIcon, AbstractGUI abstractGUI, boolean bl, JPanel jPanel, int n) {
        return this.baseDesktopPane.createInternalFrame(this.dListener, string, imageIcon, abstractGUI, bl, jPanel, n);
    }

    public void flagContentsChanged(JInternalFrame jInternalFrame) {
        this.baseDesktopPane.flagContentsChanged(jInternalFrame);
    }

    public JInternalFrame[] getAllFrames() {
        return this.baseDesktopPane.getAllFrames();
    }

    public byte getAutoMode() {
        return this.baseDesktopPane.getAutoMode();
    }

    public Component getDesktopComponentBar() {
        return this.desktopStatusBar;
    }

    public BaseInternalFrame getSelectedFrame() {
        return (BaseInternalFrame)this.baseDesktopPane.getSelectedFrame();
    }

    public WindowToolbar getWindowToolbar() {
        return this.windowToolbar;
    }

    public boolean hasFrames() {
        return this.baseDesktopPane.hasFrames();
    }

    public void hideFrame(JInternalFrame jInternalFrame) {
        this.baseDesktopPane.remove(jInternalFrame);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.dListener.itemStateChanged(itemEvent);
    }

    public void registerMenuBar(JMenuBar jMenuBar, byte by) {
        this.dMenu = new DesktopMenu(this, by);
        this.setAutoMode(by);
        jMenuBar.add(this.dMenu);
        jMenuBar.setBorder(null);
    }

    public void removeAssociatedComponents(BaseInternalFrame baseInternalFrame) {
        if (this.desktopStatusBar != null) {
            if (baseInternalFrame.getAssociatedButton() != null) {
                this.desktopStatusBar.remove(baseInternalFrame.getAssociatedButton());
            }
            this.desktopStatusBar.removeFrame(baseInternalFrame);
        }
        if (this.dMenu != null) {
            this.dMenu.remove(baseInternalFrame.getAssociatedMenuButton());
        }
        this.baseDesktopPane.selectNextFrame();
    }

    public void resizeDesktop() {
        this.baseDesktopPane.resizeDesktop();
    }

    public void revalidateViewport() {
        this.baseDesktopPane.revalidate();
    }

    public void setAllFramesMaximum(boolean bl) {
        this.baseDesktopPane.maximumInternalFrames(bl);
    }

    public void setAutoMode(byte by) {
        byte by2 = this.baseDesktopPane.getAutoMode();
        if (by2 != 2) {
            this.lastMode = by2;
        }
        this.baseDesktopPane.setAutoMode(by, true);
        if (this.windowToolbar != null) {
            this.windowToolbar.setAutoMode(by);
        }
        this.updateAutoMode(by);
        if (IniManager.isMacOS()) {
            SwingUtilities.invokeLater(() -> this.baseDesktopPane.repaint());
        }
    }

    public void setLastMode() {
        this.setAutoMode(this.lastMode);
    }

    public void setSelectedFrame(JInternalFrame jInternalFrame) {
        this.baseDesktopPane.setSelectedFrame(jInternalFrame);
    }

    public void showFrame(JInternalFrame jInternalFrame) {
        this.baseDesktopPane.add(jInternalFrame);
    }

    public void tileInternalFrames() {
        this.baseDesktopPane.tileInternalFrames();
    }

    public void updateAutoMode(byte by) {
        this.dMenu.updateAutoMode(by);
    }

    @Override
    protected void cleanUpChild() {
        if (this.dListener != null) {
            if (this.mainPane != null) {
                this.mainPane.removeComponentListener(this.dListener);
            }
            this.dListener.cleanUp();
        }
        if (this.baseDesktopPane != null) {
            this.baseDesktopPane.cleanUp();
        }
        if (this.desktopStatusBar != null) {
            this.desktopStatusBar.cleanUp();
        }
        if (this.dMenu != null) {
            this.dMenu.cleanUp();
        }
        if (this.windowToolbar != null) {
            this.windowToolbar.cleanUp();
        }
    }

    private void createFrameAssociates(BaseInternalFrame baseInternalFrame) {
        baseInternalFrame.addInternalFrameListener(this.dListener);
        if (this.desktopStatusBar != null) {
            this.desktopStatusBar.addFrame(baseInternalFrame);
        }
        if (this.dMenu != null) {
            this.dMenu.add(baseInternalFrame);
        }
        if (this.baseDesktopPane.getAutoTile()) {
            this.baseDesktopPane.tileInternalFrames();
        }
    }
}

