/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import se.prediktera.map.common.CMenu;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.BaseRadioButtonMenuItem;
import se.prediktera.map.common.swing.scrollabledesktop.ConstructWindowMenu;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopMediator;

public class DesktopMenu
extends CMenu
implements ActionListener {
    private DesktopMediator desktopMediator;
    private final int baseItemsEndIndex;
    private final ButtonGroup frameRadioButtonMenuItemGroup;
    private final JRadioButtonMenuItem tilehorizontal;
    private final JRadioButtonMenuItem tilevertical;
    private final JRadioButtonMenuItem cascade;
    private final JRadioButtonMenuItem maximum;

    public DesktopMenu(DesktopMediator desktopMediator) {
        this(desktopMediator, 1);
    }

    public DesktopMenu(DesktopMediator desktopMediator, byte by) {
        super("Window", false);
        this.setMnemonic(87);
        this.desktopMediator = desktopMediator;
        this.frameRadioButtonMenuItemGroup = new ButtonGroup();
        ConstructWindowMenu constructWindowMenu = new ConstructWindowMenu(this, by);
        this.tilehorizontal = constructWindowMenu.tilehorizontal;
        this.tilevertical = constructWindowMenu.tilevertical;
        this.cascade = constructWindowMenu.cascade;
        this.maximum = constructWindowMenu.maximum;
        this.baseItemsEndIndex = this.getItemCount();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.desktopMediator.actionPerformed(actionEvent);
    }

    public void add(BaseInternalFrame baseInternalFrame) {
        int n = this.getItemCount() - this.baseItemsEndIndex + 1;
        int n2 = n;
        if (n2 > 9) {
            n2 /= 10;
        }
        BaseRadioButtonMenuItem baseRadioButtonMenuItem = new BaseRadioButtonMenuItem(this, n + " " + baseInternalFrame.getTitle(), 48 + n2, -1, true, baseInternalFrame);
        baseInternalFrame.setAssociatedMenuButton(baseRadioButtonMenuItem);
        this.add(baseRadioButtonMenuItem);
        this.frameRadioButtonMenuItemGroup.add(baseRadioButtonMenuItem);
        baseRadioButtonMenuItem.setSelected(true);
    }

    public void remove(JRadioButtonMenuItem jRadioButtonMenuItem) {
        this.frameRadioButtonMenuItemGroup.remove(jRadioButtonMenuItem);
        super.remove(jRadioButtonMenuItem);
        this.refreshMenu();
    }

    public void updateAutoMode(byte by) {
        switch (by) {
            case 0: {
                this.tilehorizontal.setSelected(true);
                break;
            }
            case 3: {
                this.tilevertical.setSelected(true);
                break;
            }
            case 1: {
                this.cascade.setSelected(true);
                break;
            }
            case 2: {
                this.maximum.setSelected(true);
            }
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.desktopMediator = null;
    }

    private void refreshMenu() {
        Enumeration<AbstractButton> enumeration = this.frameRadioButtonMenuItemGroup.getElements();
        int n = 1;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            BaseRadioButtonMenuItem baseRadioButtonMenuItem = (BaseRadioButtonMenuItem)enumeration.nextElement();
            n2 = n;
            if (n2 > 9) {
                n2 /= 10;
            }
            baseRadioButtonMenuItem.setMnemonic(48 + n2);
            baseRadioButtonMenuItem.setText(n + " " + baseRadioButtonMenuItem.getAssociatedFrame().getTitle());
            ++n;
        }
    }
}

