/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.common.swing.scrollabledesktop.BaseComboBox;
import se.prediktera.map.common.swing.scrollabledesktop.BaseFrameInterface;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopConstants;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopMediator;
import se.prediktera.map.main.AbstractGUI;
import se.prediktera.map.main.window.AbstractWindow;

public class DesktopStatusBar
extends CleanUpPanel
implements DesktopConstants,
ActionListener,
ItemListener {
    private BaseFrameInterface frameInterface;
    private DesktopMediator desktopMediator;

    public DesktopStatusBar(String string, DesktopMediator desktopMediator) {
        super(string);
        this.desktopMediator = desktopMediator;
        this.frameInterface = new BaseComboBox();
        this.frameInterface.addItemListener(this);
        this.frameInterface.addActionListener(actionEvent -> {
            BaseInternalFrame baseInternalFrame = this.frameInterface.getAssociatedFrame();
            if (baseInternalFrame == null) {
                return;
            }
            AbstractGUI abstractGUI = baseInternalFrame.getFrameGUI();
            if (abstractGUI instanceof AbstractWindow) {
                ((AbstractWindow)abstractGUI).showProperties();
            }
        });
        JComponent jComponent = (JComponent)((Object)this.frameInterface);
        jComponent.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)jComponent, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.desktopMediator.actionPerformed(actionEvent);
    }

    public void addFrame(BaseInternalFrame baseInternalFrame) {
        this.frameInterface.addItem(baseInternalFrame);
        this.frameInterface.setSelectedItem(baseInternalFrame);
        baseInternalFrame.setAssociatedFrameInterface(this.frameInterface);
    }

    public void addPopupMenu(MouseAdapter mouseAdapter) {
        this.frameInterface.addPopupMenu(mouseAdapter);
    }

    public BaseFrameInterface getFrameInterface() {
        return this.frameInterface;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.desktopMediator != null) {
            this.desktopMediator.itemStateChanged(itemEvent);
        }
    }

    public void removeFrame(BaseInternalFrame baseInternalFrame) {
        if (this.frameInterface != null && baseInternalFrame != null) {
            this.frameInterface.removeItem(baseInternalFrame);
        }
    }

    @Override
    protected void cleanUpChild() {
        if (this.frameInterface != null) {
            this.frameInterface.cleanUp();
            this.frameInterface = null;
        }
        this.desktopMediator = null;
    }
}

