/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JInternalFrame;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.swing.scrollabledesktop.BaseDesktopPane;
import se.prediktera.map.common.swing.scrollabledesktop.BaseInternalFrame;
import se.prediktera.map.common.swing.scrollabledesktop.DesktopConstants;
import se.prediktera.map.common.swing.scrollabledesktop.TileSorter;

public class FramePositioning
extends CleanUpClass
implements DesktopConstants {
    public static final byte NONE = -1;
    public static final byte TILEHORIZONTAL = 0;
    public static final byte CASCADE = 1;
    public static final byte MAXIMUM = 2;
    public static final byte TILEVERTICAL = 3;
    private BaseDesktopPane baseDesktopPane;
    private byte autoMode;
    private final TileSorter tileSorter = new TileSorter();

    public FramePositioning(BaseDesktopPane baseDesktopPane) {
        this.baseDesktopPane = baseDesktopPane;
    }

    public Point cascadeInternalFrame(JInternalFrame jInternalFrame) {
        return this.cascadeInternalFrame(jInternalFrame, this.baseDesktopPane.getNumberOfFrames());
    }

    public void cascadeInternalFrames() {
        JInternalFrame[] jInternalFrameArray = this.baseDesktopPane.getAllFrames();
        int n = 0;
        for (int i = jInternalFrameArray.length - 1; i >= 0; --i) {
            BaseInternalFrame baseInternalFrame = (BaseInternalFrame)jInternalFrameArray[i];
            if (baseInternalFrame.isIcon()) continue;
            baseInternalFrame.setSize(baseInternalFrame.getInitialDimensions());
            baseInternalFrame.setLocation(this.cascadeInternalFrame(baseInternalFrame, n++));
        }
    }

    public byte getAutoMode() {
        return this.autoMode;
    }

    public boolean isOneFrameMaximized() {
        JInternalFrame[] jInternalFrameArray = this.baseDesktopPane.getAllFrames();
        for (int i = jInternalFrameArray.length - 1; i >= 0; --i) {
            if (!jInternalFrameArray[i].isMaximum()) continue;
            return true;
        }
        return false;
    }

    public void maximumInternalFrame(JInternalFrame jInternalFrame, boolean bl) {
        if (jInternalFrame != null && jInternalFrame.isMaximum() != bl) {
            try {
                jInternalFrame.setMaximum(bl);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void maximumInternalFrames(boolean bl) {
        JInternalFrame[] jInternalFrameArray;
        BaseInternalFrame baseInternalFrame = (BaseInternalFrame)this.baseDesktopPane.getSelectedFrame();
        for (JInternalFrame jInternalFrame : jInternalFrameArray = this.baseDesktopPane.getAllFrames()) {
            BaseInternalFrame baseInternalFrame2 = (BaseInternalFrame)jInternalFrame;
            if (baseInternalFrame2 == null || baseInternalFrame2.isIcon() || baseInternalFrame2.getFrameGUI() == null) continue;
            this.maximumInternalFrame(baseInternalFrame2, bl);
        }
        if (baseInternalFrame != this.baseDesktopPane.getSelectedFrame()) {
            this.baseDesktopPane.setSelectedFrame(baseInternalFrame);
        }
    }

    public void setAutoMode(byte by, boolean bl) {
        this.autoMode = by;
        this.tileSorter.setAutoMode(by);
        if (bl) {
            switch (by) {
                case 0: 
                case 3: {
                    this.tileInternalFrames();
                    break;
                }
                case 1: {
                    this.cascadeInternalFrames();
                    break;
                }
                case 2: {
                    this.maximumInternalFrames(true);
                }
            }
        }
    }

    public void tileInternalFrames() {
        this.baseDesktopPane.setVisible(false);
        Rectangle rectangle = this.baseDesktopPane.getVisibleRect();
        Vector vector = this.sortTileFrames();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (!vector.isEmpty() && rectangle.width > 0 && rectangle.height > 0) {
            if (this.autoMode == 0) {
                int n4 = (int)Math.sqrt(vector.size());
                int n5 = rectangle.width / n4;
                for (n = 0; n < n4; ++n) {
                    int n6 = vector.size() / n4;
                    int n7 = vector.size() % n4;
                    if (n4 - n <= n7) {
                        ++n6;
                    }
                    int n8 = rectangle.height / n6;
                    for (n2 = 0; n2 < n6; ++n2) {
                        BaseInternalFrame baseInternalFrame = (BaseInternalFrame)vector.elementAt(n3++);
                        baseInternalFrame.setBounds(n * n5, n2 * n8, n5, n8);
                    }
                }
            } else {
                int n9 = (int)Math.sqrt(vector.size());
                int n10 = rectangle.height / n9;
                for (n2 = 0; n2 < n9; ++n2) {
                    int n11 = vector.size() / n9;
                    int n12 = vector.size() % n9;
                    if (n9 - n2 <= n12) {
                        ++n11;
                    }
                    int n13 = rectangle.width / n11;
                    for (n = 0; n < n11; ++n) {
                        BaseInternalFrame baseInternalFrame = (BaseInternalFrame)vector.elementAt(n3++);
                        baseInternalFrame.setBounds(n * n13, n2 * n10, n13, n10);
                    }
                }
            }
        }
        this.baseDesktopPane.setVisible(true);
    }

    @Override
    protected void cleanUpChild() {
        this.baseDesktopPane = null;
    }

    private Point cascadeInternalFrame(JInternalFrame jInternalFrame, int n) {
        int n2;
        try {
            jInternalFrame.setMaximum(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        int n3 = jInternalFrame.getWidth();
        int n4 = jInternalFrame.getHeight();
        Rectangle rectangle = this.baseDesktopPane.getVisibleRect();
        int n5 = (rectangle.width - n3) / 30;
        if (n5 < 1) {
            n5 = 1;
        }
        if ((n2 = (rectangle.height - n4) / 30) < 1) {
            n2 = 1;
        }
        int n6 = rectangle.x + 30 * (n + 1 - (n5 - 1) * (n / n5));
        int n7 = rectangle.y + 30 * (n + 1 - n2 * (n / n2));
        return new Point(n6, n7);
    }

    private Vector sortTileFrames() {
        JInternalFrame[] jInternalFrameArray;
        Vector<BaseInternalFrame> vector = new Vector<BaseInternalFrame>();
        for (JInternalFrame jInternalFrame : jInternalFrameArray = this.baseDesktopPane.getAllFrames()) {
            BaseInternalFrame baseInternalFrame = (BaseInternalFrame)jInternalFrame;
            this.maximumInternalFrame(baseInternalFrame, false);
            if (baseInternalFrame.isIcon() || baseInternalFrame.getLayer() != 0) continue;
            vector.add(baseInternalFrame);
        }
        Collections.sort(vector, this.tileSorter);
        return vector;
    }
}

