/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.scrollabledesktop;

import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import se.prediktera.map.common.cleanup.CleanUpToolBar;

public class ResizableToolBar
extends CleanUpToolBar
implements ComponentListener {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final int minButtonWidth;
    private final int maxButtonWidth;

    private static void assignWidth(JToggleButton jToggleButton, int n) {
        jToggleButton.setMinimumSize(new Dimension(n - 2, jToggleButton.getPreferredSize().height));
        jToggleButton.setPreferredSize(new Dimension(n, jToggleButton.getPreferredSize().height));
        Dimension dimension = jToggleButton.getPreferredSize();
        jToggleButton.setMaximumSize(dimension);
        jToggleButton.setSize(dimension);
    }

    public ResizableToolBar(int n, int n2) {
        this.setFloatable(false);
        this.minButtonWidth = n;
        this.maxButtonWidth = n2;
        this.addComponentListener(this);
    }

    public void add(AbstractButton abstractButton) {
        this.buttonGroup.add(abstractButton);
        super.add(abstractButton);
        abstractButton.setSelected(true);
        this.resizeButtons();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.resizeButtons();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    public int getButtonCount() {
        return this.buttonGroup.getButtonCount();
    }

    public Enumeration getElements() {
        return this.buttonGroup.getElements();
    }

    public void remove(AbstractButton abstractButton) {
        if (abstractButton == null) {
            return;
        }
        super.remove(abstractButton);
        this.buttonGroup.remove(abstractButton);
        this.resizeButtons();
        this.repaint();
    }

    @Override
    protected void cleanUpChild() {
    }

    private float getCurrentButtonWidth() {
        int n = this.getWidth() - this.getInsets().left - this.getInsets().right;
        float f = n <= 0 ? (float)this.maxButtonWidth : (float)n;
        int n2 = this.getButtonCount();
        if (n2 > 0) {
            f /= (float)n2;
        }
        if (f < (float)this.minButtonWidth) {
            f = this.minButtonWidth;
        } else if (f > (float)this.maxButtonWidth) {
            f = this.maxButtonWidth;
        }
        return f;
    }

    private void resizeButtons() {
        float f = this.getCurrentButtonWidth();
        if (this.getOrientation() == 1) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            JToggleButton jToggleButton = null;
            Enumeration enumeration = this.getElements();
            float f2 = 0.0f;
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
                if (!(abstractButton instanceof JToggleButton)) continue;
                jToggleButton = (JToggleButton)abstractButton;
                int n = Math.round(f2 + f) - Math.round(f2);
                ResizableToolBar.assignWidth(jToggleButton, n);
                f2 += f;
            }
            this.revalidate();
        });
    }
}

