/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.table;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class TableAction {
    public static void enableTabAction(JTable jTable) {
        if (SwingUtilities.isEventDispatchThread()) {
            TableAction.setTabAction(jTable);
            TableAction.setEnterAction(jTable);
        } else {
            SwingUtilities.invokeLater(() -> {
                TableAction.setTabAction(jTable);
                TableAction.setEnterAction(jTable);
            });
        }
    }

    private static void setEnterAction(JTable jTable) {
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "move-to-next-editable-cell");
        jTable.getActionMap().put("move-to-next-editable-cell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                JTable jTable = (JTable)actionEvent.getSource();
                if (jTable.isEditing()) {
                    n2 = jTable.getEditingRow();
                    n = jTable.getEditingColumn() + 1;
                } else {
                    n2 = jTable.getSelectionModel().getAnchorSelectionIndex();
                    if (n2 == -1 && jTable.getRowCount() == 0) {
                        return;
                    }
                    n = jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                    if (n == -1 && jTable.getColumnCount() == 0) {
                        return;
                    }
                    if (!jTable.getCellSelectionEnabled()) {
                        n = 0;
                    }
                }
                int n3 = jTable.getRowCount();
                int n4 = jTable.getColumnCount();
                int n5 = n2;
                boolean bl = true;
                boolean bl2 = false;
                while (!bl2) {
                    while (n2 < n3) {
                        if (n2 == n5) {
                            if (!bl) {
                                bl2 = true;
                                break;
                            }
                            bl = false;
                        }
                        while (n < n4) {
                            if (jTable.isCellEditable(n2, n)) {
                                jTable.clearSelection();
                                jTable.changeSelection(n2, n, true, false);
                                jTable.editCellAt(n2, n);
                                jTable.requestFocus();
                                return;
                            }
                            ++n;
                        }
                        ++n2;
                        n = 0;
                    }
                    n = 0;
                    n2 = 0;
                }
            }
        });
    }

    private static void setTabAction(JTable jTable) {
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "move-to-next-valid-cell");
        jTable.getInputMap(1).put(KeyStroke.getKeyStroke(9, 1), "move-to-next-valid-cell");
        jTable.getActionMap().put("move-to-next-valid-cell", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTable jTable = (JTable)actionEvent.getSource();
                if (jTable.getRowSelectionAllowed() && !jTable.getColumnModel().getColumnSelectionAllowed()) {
                    ListSelectionModel listSelectionModel = jTable.getSelectionModel();
                    int n = 0;
                    if (actionEvent.getModifiers() == 1) {
                        n = listSelectionModel.getAnchorSelectionIndex() > 0 ? listSelectionModel.getAnchorSelectionIndex() - 1 : jTable.getRowCount() - 1;
                    } else if (listSelectionModel.getAnchorSelectionIndex() < jTable.getRowCount() - 1) {
                        n = listSelectionModel.getAnchorSelectionIndex() + 1;
                    }
                    listSelectionModel.setSelectionInterval(n, n);
                    Rectangle rectangle = jTable.getCellRect(n, 0, true);
                    jTable.scrollRectToVisible(rectangle);
                } else if (jTable.getCellSelectionEnabled()) {
                    int n;
                    int n2 = jTable.getSelectionModel().getAnchorSelectionIndex();
                    if (n2 == -1) {
                        if (jTable.getRowCount() == 0) {
                            return;
                        }
                        n2 = 0;
                    }
                    if ((n = jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex()) == -1) {
                        if (jTable.getColumnCount() == 0) {
                            return;
                        }
                        n = 0;
                    }
                    int n3 = jTable.getRowCount();
                    int n4 = jTable.getColumnCount();
                    if (actionEvent.getModifiers() == 1) {
                        --n;
                        while (n2 > -1) {
                            if (n > -1) {
                                jTable.changeSelection(n2, n, true, false);
                                jTable.requestFocus();
                                return;
                            }
                            --n2;
                            n = n4 - 1;
                        }
                        jTable.changeSelection(n3 - 1, n4 - 1, true, false);
                    } else {
                        ++n;
                        while (n2 < n3) {
                            if (n < n4) {
                                jTable.changeSelection(n2, n, true, false);
                                jTable.requestFocus();
                                return;
                            }
                            ++n2;
                            n = 0;
                        }
                        jTable.changeSelection(0, 0, true, false);
                    }
                } else {
                    ListSelectionModel listSelectionModel = jTable.getColumnModel().getSelectionModel();
                    int n = 0;
                    if (actionEvent.getModifiers() == 1) {
                        n = listSelectionModel.getAnchorSelectionIndex() > 0 ? listSelectionModel.getAnchorSelectionIndex() - 1 : jTable.getColumnCount() - 1;
                    } else if (listSelectionModel.getAnchorSelectionIndex() < jTable.getColumnCount() - 1) {
                        n = listSelectionModel.getAnchorSelectionIndex() + 1;
                    }
                    listSelectionModel.setSelectionInterval(n, n);
                    Rectangle rectangle = jTable.getCellRect(0, n, true);
                    jTable.scrollRectToVisible(rectangle);
                }
            }
        });
    }

    public void selectNextEditableCell(JTable jTable, int n, int n2) {
        int n3 = n;
        if (n3 == -1 && jTable.getRowCount() == 0) {
            return;
        }
        int n4 = n2;
        if (n4 == -1) {
            if (jTable.getColumnCount() == 0) {
                return;
            }
        } else {
            ++n4;
        }
        if (!jTable.getCellSelectionEnabled()) {
            n4 = 0;
        }
        int n5 = jTable.getRowCount();
        int n6 = jTable.getColumnCount();
        int n7 = n3;
        boolean bl = true;
        boolean bl2 = false;
        while (!bl2) {
            while (n3 < n5) {
                if (n3 == n7) {
                    if (!bl) {
                        bl2 = true;
                        break;
                    }
                    bl = false;
                }
                while (n4 < n6) {
                    if (jTable.isCellEditable(n3, n4)) {
                        jTable.changeSelection(n3, n4, false, false);
                        return;
                    }
                    ++n4;
                }
                ++n3;
                n4 = 0;
            }
            n4 = 0;
            n3 = 0;
        }
    }
}

