/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.tree;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;

public class WideMouseListener
extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (!(object instanceof JTree)) {
            return;
        }
        JTree jTree = (JTree)object;
        int n = jTree.getClosestRowForLocation(0, mouseEvent.getY());
        Rectangle rectangle = jTree.getPathBounds(jTree.getPathForRow(n));
        if (rectangle == null || mouseEvent.getX() <= rectangle.x + rectangle.width) {
            return;
        }
        if (mouseEvent.isControlDown()) {
            if (jTree.isRowSelected(n)) {
                jTree.removeSelectionRow(n);
            } else {
                jTree.addSelectionRow(n);
            }
        } else if (mouseEvent.isShiftDown()) {
            int[] nArray = jTree.getSelectionRows();
            if (nArray == null || nArray.length == 0) {
                jTree.setSelectionRow(n);
            } else if (jTree.isRowSelected(n)) {
                for (int n2 : nArray) {
                    if (n2 == n) continue;
                    jTree.removeSelectionRow(n2);
                }
            } else {
                int n3;
                for (n3 = n; n3 < nArray[0]; ++n3) {
                    jTree.addSelectionRow(n3);
                }
                for (n3 = nArray[nArray.length - 1] + 1; n3 <= n; ++n3) {
                    jTree.addSelectionRow(n3);
                }
            }
        } else {
            jTree.setSelectionRow(n);
        }
        mouseEvent.consume();
    }
}

