/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import javax.swing.JTree;
import javax.swing.JViewport;
import se.prediktera.map.components.tree.CustomNodeRenderer;

public class WideNodeRenderer
extends CustomNodeRenderer {
    private JTree tree;

    public WideNodeRenderer() {
        this.setOpaque(false);
        this.setBackground(null);
        this.setBackgroundNonSelectionColor(null);
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.tree = jTree;
        return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Color color;
        if (this.selected && (color = this.getBackgroundSelectionColor()) != null) {
            Shape shape = graphics.getClip();
            JViewport jViewport = (JViewport)this.tree.getParent();
            Point point = jViewport.getViewPosition();
            int n = (int)shape.getBounds().getX();
            int n2 = jViewport.getWidth() - this.getX() + (int)point.getX() - n;
            graphics.setClip(n, 0, n2, (int)shape.getBounds().getHeight());
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.tree.getWidth(), this.getHeight());
            graphics.setClip(shape);
        }
        super.paintComponent(graphics);
    }
}

