/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.map.common.tools3d;

import com.jogamp.opengl.glu.GLU;
import java.io.IOException;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import se.prediktera.map.common.MapProperty;
import se.prediktera.map.common.RandomOutputStream;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.tools3d.Orientation;

public class Camera
extends CleanUpClass {
    private GLU glu;
    private Orientation orientation;
    private Orientation oldOrient = new Orientation();
    private Orientation newOrient;
    private boolean noRoll = false;

    public Camera() {
        this(0.0, 0.0, 0.0);
    }

    public Camera(double d, double d2, double d3) {
        this(d, d2, d3, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0);
    }

    public Camera(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        super("Camera");
        this.glu = new GLU();
        this.orientation = new Orientation(d, d2, d3, d4, d5, d6, d7, d8, d9);
        this.oldOrient = new Orientation();
    }

    public Camera(GLU gLU) {
        this();
        this.glu = gLU;
    }

    public Camera(MapProperty mapProperty) throws IOException {
        this();
        this.orientation.LoadProperty(mapProperty);
    }

    public void allowRoll(boolean bl) {
        boolean bl2 = this.noRoll = !bl;
        if (this.noRoll) {
            Vector3d vector3d = new Vector3d(-this.orientation.viewDir.z, 0.0, this.orientation.viewDir.x);
            if (vector3d.lengthSquared() < 0.01) {
                vector3d.x = 1.0;
                vector3d.z = 0.0;
            }
            vector3d.normalize();
            Vector3d vector3d2 = new Vector3d(this.orientation.viewDir.x, this.orientation.viewDir.y, this.orientation.viewDir.z);
            vector3d2.cross(vector3d, vector3d2);
            vector3d2.normalize();
            this.orientation.up.x = vector3d2.x;
            this.orientation.up.y = vector3d2.y;
            this.orientation.up.z = vector3d2.z;
        }
    }

    public void copyOrientation(Orientation orientation) {
        this.orientation.copyTo(orientation);
    }

    public double[] getPosition() {
        return this.orientation.position;
    }

    public void interpolate(double d) {
        this.orientation.interPolate(this.oldOrient, this.newOrient, d);
    }

    public void moveAhead(double d) {
        this.orientation.moveAhead(d);
    }

    public void moveUp(double d) {
        this.orientation.moveUp(d);
    }

    public void rotateByMouse(double d, double d2) {
        if (this.noRoll) {
            this.rotateView(-Math.PI * d / 180.0, 0.0, 1.0, 0.0);
        } else {
            this.rotateView(-Math.PI * d / 180.0);
        }
        Vector3d vector3d = new Vector3d(this.orientation.up.x, this.orientation.up.y, this.orientation.up.z);
        Vector3d vector3d2 = new Vector3d(this.orientation.viewDir.x, this.orientation.viewDir.y, this.orientation.viewDir.z);
        vector3d.cross(vector3d, vector3d2);
        this.rotateView(Math.PI * d2 / 180.0, vector3d.x, vector3d.y, vector3d.z);
        this.orientation.normalize();
    }

    public void rotateView(double d) {
        this.rotateView(d, this.orientation.up.x, this.orientation.up.y, this.orientation.up.z);
    }

    public void rotateView(double d, double d2, double d3, double d4) {
        double d5 = Math.sin(d * 0.5);
        Quat4d quat4d = new Quat4d(d2 * d5, d3 * d5, d4 * d5, Math.cos(d * 0.5));
        Quat4d quat4d2 = new Quat4d();
        quat4d2.mul(quat4d, this.orientation.viewDir);
        Quat4d quat4d3 = new Quat4d();
        quat4d3.conjugate(quat4d);
        this.orientation.viewDir.mul(quat4d2, quat4d3);
        quat4d2.mul(quat4d, this.orientation.up);
        this.orientation.up.mul(quat4d2, quat4d3);
    }

    public void SaveProperty(RandomOutputStream randomOutputStream) throws IOException {
        this.orientation.SaveProperty(randomOutputStream);
    }

    public void setGLU() {
        this.glu = new GLU();
    }

    public void startInterpolation(Orientation orientation) {
        this.copyOrientation(this.oldOrient);
        this.newOrient = orientation;
    }

    public void view() {
        this.orientation.view(this.glu);
    }

    public void viewNoMove() {
        this.orientation.viewNoMove(this.glu);
    }

    @Override
    protected void cleanUpChild() {
        this.glu = null;
        if (this.orientation != null) {
            this.orientation.cleanUp();
            this.orientation = null;
        }
        if (this.oldOrient != null) {
            this.oldOrient.cleanUp();
            this.oldOrient = null;
        }
        if (this.newOrient != null) {
            this.newOrient.cleanUp();
            this.newOrient = null;
        }
    }
}

